# $FreeWRT$
#-
# This file is part of the FreeWRT project. FreeWRT is copyrighted
# material, please see the LICENCE file in the top-level directory
# or at http://www.freewrt.org/license for details.

define target_template
ifeq ($(FWRT_LINUX_$(4)),y)
KERNEL:=$(1)
BOARD:=$(2)
MODEL:=$(3)
FWRT_LAN:=$(5)
FWRT_WAN:=$(6)
FWRT_WLAN:=$(7)
FWRT_SWITCH:=$(8)
endif
endef

# asus models
$(eval $(call target_template,2.4,brcm,asus-wl500g,2_4_BRCM_ASUS_WL500G,eth0,eth1,eth2,n))
$(eval $(call target_template,2.4,brcm,asus-wl500g-deluxe,2_4_BRCM_ASUS_WL500G_DELUXE,eth0.0,eth0.1,eth1,y))
$(eval $(call target_template,2.4,brcm,asus-wl500g-premium,2_4_BRCM_ASUS_WL500G_PREMIUM,eth0.0,eth0.1,eth2,y))
# linksys models
$(eval $(call target_template,2.4,brcm,linksys-wrt54gs-10,2_4_BRCM_LINKSYS_WRT54GS_10,eth0.0,eth0.1,eth1,y))
$(eval $(call target_template,2.4,brcm,linksys-wrt54gs-11,2_4_BRCM_LINKSYS_WRT54GS_11,eth0.0,eth0.1,eth1,y))
$(eval $(call target_template,2.4,brcm,linksys-wrt54gs-4,2_4_BRCM_LINKSYS_WRT54GS_4,eth0.0,eth0.1,eth1,r))
$(eval $(call target_template,2.4,brcm,linksys-wrt54g-20,2_4_BRCM_LINKSYS_WRT54G_20,eth0.0,eth0.1,eth1,y))
$(eval $(call target_template,2.4,brcm,linksys-wrt54g-22,2_4_BRCM_LINKSYS_WRT54G_22,eth0.0,eth0.1,eth1,y))
$(eval $(call target_template,2.4,brcm,linksys-wrt54g-30,2_4_BRCM_LINKSYS_WRT54G_30,eth0.0,eth0.1,eth1,y))
$(eval $(call target_template,2.4,brcm,linksys-wrt54g-31,2_4_BRCM_LINKSYS_WRT54G_31,eth0.0,eth0.1,eth1,y))
$(eval $(call target_template,2.4,brcm,linksys-wrt54g-4,2_4_BRCM_LINKSYS_WRT54G_4,eth0.0,eth0.1,eth1,y))
$(eval $(call target_template,2.4,brcm,linksys-wrt54gl,2_4_BRCM_LINKSYS_WRT54GL,eth0.0,eth0.1,eth1,r))
$(eval $(call target_template,2.4,brcm,linksys-wrt54g3g,2_4_BRCM_LINKSYS_WRT54G3G,eth0.0,eth0.1,eth1,y))
# netgear models
$(eval $(call target_template,2.4,brcm,netgear-wgt634u,2_4_BRCM_NETGEAR_WGT634U,eth0.0,eth0.1,ath0,r))

# set kernel version
ifeq ($(KERNEL),2.4)
KERNEL_VERSION=2.4.33.3
KERNEL_RELEASE=1
KERNEL_MOD_SUFFIX=o
endif

# set architecture
ifeq ($(BOARD),brcm)
CPU_ARCH=mipsel
KERNEL_ARCH=mips
endif


export BOARD
export CPU_ARCH
export KERNEL_ARCH
export KERNEL
export KERNEL_VERSION
export MODEL
export FWRT_LAN
export FWRT_WAN
export FWRT_WLAN
export FWRT_SWITCH

define rootfs_template
ifeq ($(FWRT_TARGET_ROOTFS_$(2)),y)
FS:=$(1)
endif
endef

$(eval $(call rootfs_template,jffs2,JFFS2))
$(eval $(call rootfs_template,squashfs-overlay,SQUASHFS_OVERLAY))

export FS

FWRT_VERSION=1.0
export FWRT_VERSION
