#!/bin/sh
# $Id$
#
# tftp flash script for wireless routers
#
# Copyright (c) 2006 by Thorsten Glaser <tg@mirbsd.de>
# Copyright (C) 2006 by Waldemar Brodkorb <wbx@freewrt.org>
# Copyright (C) 2004 by Oleg I. Vdovikin <oleg@cs.msu.su>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

usage() {
	cat <<EOF
Usage: $0 firmware.bin [address]

The following models are supported:
  asus-wl500g		- Asus WL500g
  asus-wl500g-deluxe	- Asus WL500g Deluxe
  asus-wl500g-premium	- Asus WL500g Premium
  linksys		- All Linksys models

IMPORTANT:
Notes for Linksys routers:
   be sure you have set boot_wait to yes. Power on your router
   after executing this script.

Notes for Asus routers:
   be sure POWER led is flashing (If this is not the case
   poweroff the device, push the reset button & power on
   it again, then release button)

1) connect your PC to the LAN port
2) be sure your link is up and has an address in the
   192.168.1.0/24 address range (other than 192.168.1.1)
   or specify an IP address where to flash to

EOF
	exit 1
}

file=${1:-/nonexistant}
ip=${2:-192.168.1.1}

test -s "$file" || usage

case $file in
*-asus-wl500g-deluxe-*.bin | *-asus-wl500g-premium-*.bin)
	echo Flashing $ip using "$file"...
	echo -en "rexmt 1\ntrace\nbinary\nput $file\nquit\n" | tftp $ip
	echo Please wait 5-7 minutes and then remove the power.
	echo This device does not reboot automatically after flashing.
	;;
*-asus-wl500g-*.bin)
	echo Confirming IP address setting...
	echo -en "get ASUSSPACELINK\x01\x01\xa8\xc0 /dev/null\nquit\n" | tftp $ip
	echo Flashing $ip using "$file"...
	echo -en "binary\nput $file ASUSSPACELINK\nquit\n" | tftp $ip
	echo Please wait until leds stops flashing. Device will automatically reboot.
	;;
*-linksys-*.bin)
	echo Flashing $ip using "$file"...
	echo -en "rexmt 1\ntrace\nbinary\nput $file\nquit\n" | tftp $ip
	echo Unit will automatically reboot within 3-7 minutes.  Do not power off.
	;;
*)
	echo Unsupported model "'$file'"
	usage
	;;
esac
echo After that you can login via: ssh admin@$ip
echo Default password, unless changed in menuconfig, is: FreeWRT
