#!/bin/sh
#
# This file is part of the FreeWRT project. FreeWRT is copyrighted
# material, please see the LICENCE file in the top-level directory
# or at http://www.freewrt.org/licence for details.
#
# Christian Fischer <spaetzle@freewrt.org>
#

GOOD='\x1B[32;01m'
WARN='\x1B[33;01m'
BAD='\x1B[31;01m'
HILITE='\x1B[36;01m'
BRACKET='\x1B[34;01m'
NORMAL='\x1B[0m'

TAB=2
ENDCOL='\x1B[200C\x1B[6D'
FIRSTCOL='\x0D'
MP_GOOD=" ${GOOD}*${NORMAL} "
MP_BAD=" ${BAD}*${NORMAL} "
MP_NONE='\x1B[3C'
ME_GOOD="${ENDCOL}${BRACKET}[ ${GOOD}ok${BRACKET} ]"
ME_BAD="${ENDCOL}${BRACKET}[ ${BAD}!!${BRACKET} ]"


mprint() {
	local opt msg logmsg color chars savelastlog
	case $1 in
		-n)
		shift
		opt='-ne'
#		msg="${MPREFIX}${STARTCOL}${MCOLOR}${1}"
		msg="${FIRSTCOL}${MP_GOOD}${STARTCOL}${1}"

		logmsg=$1
		savelastlog=1
		;;
		-d)
		shift
		opt='-e'
		#msg="${MPREFIX}${STARTCOL}${MCOLOR}${1} ..."
		msg="${FIRSTCOL}${MP_GOOD}${STARTCOL}${1} ..."
		logmsg=$1
		;;
		-e)
		shift
		opt='-e'
		case "$1" in
			0)
			msg="${FIRSTCOL}${MP_GOOD}${ME_GOOD}"
			logmsg="ok"
			;;
			*)
			msg="${FIRSTCOL}${MP_BAD}${ME_BAD}"
			logmsg="!!"
			;;
		esac
		;;
		*)
		opt='-e'
#		msg="${MPREFIX}${STARTCOL}${MCOLOR}${1}"
#		msg="${FIRSTCOL}${MP_GOOD}${STARTCOL}${MCOLOR}${1}"
		msg="${FIRSTCOL}${MP_NONE}${STARTCOL}${1}${2}${NORMAL}"
		logmsg=$2
		;;
	esac

	config $CFG_PRINTING_OFF || echo $opt ${msg}${NORMAL}

#	if config $FWIFUD_RT_SYSLOG
#	then
	#	if config $savelastlog
	#	then
			logger -t ifupdown "$logmsg"
	#		sed -i -e "s/LASTLOG=*/LASTLOG=$logmsg/g" $ENVFILE
	#	else
	#		logger -t ifupdown "$LASTLOG : $logmsg"
	#	fi
#	fi

	MPREFIX=$MP_GOOD
}



# vim:ts=4
