#!/bin/sh
#
# This file is part of the FreeWRT project. FreeWRT is copyrighted
# material, please see the LICENCE file in the top-level directory
# or at http://www.freewrt.org/licence for details.
#
# Christian Fischer <spaetzle@freewrt.org>
#

set -u

case $(basename $0) in
	ifup)
	;;
	ifdown)
	;;
	*)
	echo "Usage: ifup|ifdown [options]"
	echo "For options see man busybox"
	exit 1
	;;
esac

CFG_BUSYBOX_COMPAT=0

if [ -f /etc/conf.d/ifupdown ]
then
	. /etc/conf.d/ifupdown
else
	CFG_BUSYBOX_COMPAT=1
fi


if [ "$CFG_BUSYBOX_COMPAT" = "1" ]
then
	busybox $(basename $0) $@
else
	# cleanup hook dirs, or should we patch busybox ???
	for dir in pre-up up down post-down
	do
		mount --bind /opt/ifupdown/hook /etc/network/if-${dir}.d
	done

	eval IFUPDOWN_ENV="" $(cat /etc/conf.d/ifupdown | sed "s/#.*//g" ) \
		busybox $(basename $0) $@ 2>&1 | sed '/^run-parts:/d'

	# restore hook dirs
	for dir in pre-up up down post-down
	do
		umount /etc/network/if-${dir}.d
	done
fi

# vim:ts=4
