# $FreeWRT$
#-
# This file is part of the FreeWRT project. FreeWRT is copyrighted
# material, please see the LICENCE file in the top-level directory
# or at http://www.freewrt.org/licence for details.

DISTFILES:=	linux-$(LINUX_VERSION).tar.bz2
MASTER_SITES=	http://www.us.kernel.org/pub/linux/kernel/v$(KERNEL)/ \
		http://www.us.kernel.org/pub/linux/kernel/v$(KERNEL)/ \
		http://www.kernel.org/pub/linux/kernel/v$(KERNEL)/ \
		http://www.de.kernel.org/pub/linux/kernel/v$(KERNEL)/
PKG_MD5SUM:=	${LINUX_KERNEL_MD5SUM}

include ${TOPDIR}/mk/buildhlp.mk

KERNEL_IDIR:=$(LINUX_BUILD_DIR)/kernel-ipkg

$(LINUX_BUILD_DIR)/.extract: ${_CHECKSUM_COOKIE}
	$(TRACE) target/linux/$(BOARD)-$(KERNEL)-kernel-prepare
	test ! -e ${LINUX_BUILD_DIR}/linux-${LINUX_VERSION}/Rules.make || \
	    rm -rf ${LINUX_BUILD_DIR}
	-mkdir -p $(LINUX_BUILD_DIR)
	bzcat ${FULLDISTFILES} | (cd $(LINUX_BUILD_DIR); tar xf - )
	rm -f $(BUILD_DIR)/linux
	ln -s $(LINUX_BUILD_DIR)/linux-$(LINUX_VERSION) $(BUILD_DIR)/linux
	$(TRACE) target/linux/$(BOARD)-$(KERNEL)-kernel-patch
	-[ -d ../generic-$(KERNEL)/patches ] && $(PATCH) $(LINUX_DIR) ../generic-$(KERNEL)/patches $(MAKE_TRACE)
	-[ -d ../generic-${UNAME_R}/patches ] && $(PATCH) $(LINUX_DIR) ../generic-${UNAME_R}/patches $(MAKE_TRACE)
	-[ -d ./patches ] && $(PATCH) $(LINUX_DIR) ./patches $(MAKE_TRACE)
	-[ -d ./$(DEVICE)/patches ] && $(PATCH) $(LINUX_DIR) ./$(DEVICE)/patches $(MAKE_TRACE)
	touch $@

$(LINUX_DIR)/.config: $(LINUX_BUILD_DIR)/.extract $(BUILD_DIR)/.fwrtkernelconfig
	$(TRACE) target/linux/$(BOARD)-$(KERNEL)-kernel-configure
	$(CP) $(BUILD_DIR)/.fwrtkernelconfig $(LINUX_DIR)/.config
ifeq ($(KERNEL),2.4)
	$(SED) "s,^CROSS_COMPILE.*,CROSS_COMPILE=$(KERNEL_CROSS),g;" \
	  $(LINUX_DIR)/Makefile  \
	  $(LINUX_DIR)/arch/*/Makefile
	env GCC_HONOUR_COPTS=s $(MAKE) -C $(LINUX_DIR) ARCH=$(LINUX_KARCH) CC="$(TARGET_CC)" oldconfig include/linux/compile.h include/linux/version.h $(MAKE_TRACE)
	env GCC_HONOUR_COPTS=s $(MAKE) -C $(LINUX_DIR) CROSS_COMPILE="$(KERNEL_CROSS)" ARCH=$(LINUX_KARCH) CC="$(TARGET_CC)" dep $(MAKE_TRACE)
else
	echo N | env GCC_HONOUR_COPTS=s $(MAKE) -C $(LINUX_DIR) CROSS_COMPILE="$(KERNEL_CROSS)" ARCH=$(LINUX_KARCH) CC="$(TARGET_CC)" oldconfig $(MAKE_TRACE)
	env GCC_HONOUR_COPTS=s $(MAKE) -C $(LINUX_DIR) V=1 CROSS_COMPILE="$(KERNEL_CROSS)" ARCH=$(LINUX_KARCH) CC="$(TARGET_CC)" prepare scripts $(MAKE_TRACE) HOSTCFLAGS='-O2 -idirafter ${TOPDIR}/scripts'
endif
	touch -c $(LINUX_DIR)/.config

$(LINUX_DIR)/vmlinux: $(LINUX_DIR)/.config
	$(TRACE) target/linux/$(BOARD)-$(KERNEL)-kernel-compile
	env GCC_HONOUR_COPTS=s $(MAKE) -C $(LINUX_DIR) V=1 CROSS_COMPILE="$(KERNEL_CROSS)" ARCH=$(LINUX_KARCH) CC="$(TARGET_CC)" $(MAKE_TRACE) HOSTCFLAGS='-O2 -idirafter ${TOPDIR}/scripts'
	$(TRACE) target/linux/$(BOARD)-$(KERNEL)-modules-compile
	env GCC_HONOUR_COPTS=s $(MAKE) -C "$(LINUX_DIR)" V=1 CROSS_COMPILE="$(KERNEL_CROSS)" ARCH=$(LINUX_KARCH) CC="$(TARGET_CC)" modules $(MAKE_TRACE) HOSTCFLAGS='-O2 -idirafter ${TOPDIR}/scripts'
	$(TRACE) target/linux/$(BOARD)-$(KERNEL)-modules-install
	rm -rf $(LINUX_BUILD_DIR)/modules
	env GCC_HONOUR_COPTS=s $(MAKE) -C "$(LINUX_DIR)" V=1 CROSS_COMPILE="$(KERNEL_CROSS)" DEPMOD=true INSTALL_MOD_PATH=$(LINUX_BUILD_DIR)/modules modules_install $(MAKE_TRACE) HOSTCFLAGS='-O2 -idirafter ${TOPDIR}/scripts'
	$(TRACE) target/linux/$(BOARD)-$(KERNEL)-create-packages
	-mkdir $(BUILD_DIR)/kmod-control
	env GCC_HONOUR_COPTS=s $(MAKE) $(KERNEL_IPKG) $(TARGETS) $(MAKE_TRACE)
	touch -c $(LINUX_DIR)/vmlinux

$(LINUX_KERNEL): $(LINUX_DIR)/vmlinux
	$(TRACE) target/linux/$(BOARD)-$(KERNEL)-kernel-strip
ifeq ($(KERNEL),2.4)
ifeq ($(BOARD),brcm)
ifneq ($(FS),nfs)
	$(TARGET_CROSS)objcopy -O binary -R .reginfo -R .note -R .comment -R .mdebug -S $< $@ $(MAKE_TRACE)
else
	$(TARGET_CROSS)objcopy -R .reginfo -R .note -R .comment -R .mdebug -S $< $@ $(MAKE_TRACE)
endif
else
	$(TARGET_CROSS)objcopy -R .reginfo -R .note -R .comment -R .mdebug -S $< $@ $(MAKE_TRACE)
endif
endif

$(KERNEL_IPKG):
	$(TRACE) target/linux/$(BOARD)-$(KERNEL)-$(DEVICE)-$(FS)-create-kernel-package
	rm -rf $(KERNEL_IDIR)
	mkdir -p $(KERNEL_IDIR)/etc
	${MBSH} ${SCRIPT_DIR}/make-ipkg-dir.sh ${KERNEL_IDIR} \
	    ../kernel.control ${BOARD}-${KERNEL}-${LINUX_VERSION} ${ARCH}
	$(IPKG_BUILD) $(KERNEL_IDIR) $(PACKAGE_DIR) $(MAKE_TRACE)

prepare:
compile: $(LINUX_KERNEL)

install: compile
	env GCC_HONOUR_COPTS=s $(MAKE) $(KPKG_MAKEOPTS) $(LINUX_KERNEL) $(MAKE_TRACE)
	$(TRACE) target/linux/$(BOARD)-$(KERNEL)-modules-install
	rm -rf ${LINUX_BUILD_DIR}/root*
	cd ${BUILD_DIR} && pax -rw -pe root ${LINUX_BUILD_DIR}/
	printf '%s\n%s\n' 'dest root /' \
	    'option offline_root $(LINUX_BUILD_DIR)/root' \
	    >$(LINUX_BUILD_DIR)/ipkg.conf
ifneq ($(strip $(INSTALL_TARGETS)),)
	$(IPKG_KERNEL) install $(INSTALL_TARGETS) $(MAKE_TRACE)
endif

clean:
	rm -rf $(LINUX_BUILD_DIR)
	rm -f $(TARGETS)
