# $FreeWRT$
#
# This file is part of the FreeWRT project. FreeWRT is copyrighted
# material, please see the LICENCE file in the top-level directory
# or at http://www.freewrt.org/licence for details.
#
# Christian Fischer <spaetzle@freewrt.org>
#

GOOD='[32;01m'
WARN='[33;01m'
BAD='[31;01m'
HILITE='[36;01m'
BRACKET='[34;01m'
NORMAL='[0m'

TAB=2
ENDCOL='[200C[6D'
FIRSTCOL='
'
MP_GOOD=" ${GOOD}*${NORMAL} "
MP_BAD=" ${BAD}*${NORMAL} "
MP_NONE='[3C'
ME_GOOD="${ENDCOL}${BRACKET}[ ${GOOD}ok${BRACKET} ]${NORMAL}"
ME_BAD="${ENDCOL}${BRACKET}[ ${BAD}!!${BRACKET} ]${NORMAL}"

mprint() {
	local msg logmsg color le="\n"
	case $1 in
	-n)
		shift
		config $FWIFUPDOWN_FANCY && \
			msg="${FIRSTCOL}${MP_GOOD}${STARTCOL}${*}" || \
			msg="${FIRSTCOL}${STARTCOL}${*}"
		le=
		logmsg="$*"
		;;
	-d)
		shift
		config $FWIFUPDOWN_FANCY && \
			msg="${FIRSTCOL}${MP_GOOD}${STARTCOL}${*} ..." || \
			msg="${FIRSTCOL}${STARTCOL}${*} ..."
		logmsg=
		;;
	-e)
		shift
		case "$1" in
		0)
			config $FWIFUPDOWN_FANCY && \
				msg="${FIRSTCOL}${MP_GOOD}${ME_GOOD}" || \
				msg="${MP_NONE}ok"
			logmsg="ok"
			;;
		*)
			config $FWIFUPDOWN_FANCY && \
				msg="${FIRSTCOL}${MP_BAD}${ME_BAD}" || \
				msg="${MP_NONE}!!"
			logmsg="!!"
			;;
		esac
		;;
	-s)
		shift
		mlogger "$*"
		return 0
		;;
	*)
		color=$1
		shift
		config $FWIFUPDOWN_FANCY && \
			msg="${FIRSTCOL}${MP_NONE}${STARTCOL}${color}${*}${NORMAL}" || \
			msg="${FIRSTCOL}${STARTCOL}${*}"
		logmsg="$*"
		;;
	esac

	config $FWIFUPDOWN_PRINTING_OFF || printf "%s$le" "$msg"
	mlogger $logmsg
}

mlogger() {
	config $FWIFUPDOWN_SYSLOG_OFF || [ -z "$logmsg" ] && return
	logger -t network "$*"
}

mstart() {
	mprint -d "Starting $IFACE_TYPE $IFACE"
	MDENT=$(expr ${MDENT:-0} + 1)
	main_pos_update
}

mstop() {
	mprint -d "Stopping $IFACE_TYPE $IFACE"
	MDENT=$(expr ${MDENT:-0} + 1)
	main_pos_update
}

mup() {
	mprint -n "Bringing up $IFACE_TYPE $IFACE"
}

mdown() {
	mprint -n "Bringing down $IFACE_TYPE $IFACE"
}

madd() {
	mprint -n "Adding ${1:-$IFACE}"
}

mremove() {
	mprint -n "Removing ${1:-$IFACE}"
}

mcreate() {
	mprint -n "Creating ${2:-$IFACE_TYPE} ${1:-$IFACE}"
}

mdestroy() {
	mprint -n "Destroying ${2:-$IFACE_TYPE} ${1:-$IFACE}"
}

merr() {
	mprint "${HILITE}" "Error: ${*}"
}

minfo() {
	mprint "${HILITE}" "Info: ${*}"
}

mwarn() {
	mprint "${HILITE}" "Warning: ${*}"
}

mstate() {
	mprint -e $1
	return $1
}



# vim:ts=4
