/*
 * configfs.c -  wrapper for nvram over fuse filesystem
 *
 * Copyright (C) 2006 Joerg Seitter <js@freewrt.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */


#include <fuse.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>

// needed for nvram
#include <typedefs.h>
#include <bcmnvram.h>

static char *name, *value, buf[NVRAM_SPACE];

static int nvram_getattr(const char *path, struct stat *stbuf)
{
    int res = 0;

    memset(stbuf, 0, sizeof(struct stat));
    if(strcmp(path, "/") == 0) {
        stbuf->st_mode = S_IFDIR | 0755;
        stbuf->st_nlink = 2;
    }
    // here we have to check if the name exists
    else if(1) {
        stbuf->st_mode = S_IFREG | 0444;
        stbuf->st_nlink = 1;
        // here we get the size, lets fix it to 42, sad but true ;)
        stbuf->st_size = 42;
    }
    else
        res = -ENOENT;

    return res;
}

static int nvram_readdir(const char *path, void *buf, fuse_fill_dir_t filler,
                         off_t offset, struct fuse_file_info *fi)
{
    (void) offset;
    (void) fi;

    //here we get the list of all nvram vars
    nvram_getall(buf,sizeof(buf));
    // iterate over one enty
   // for (name = buf; *name; name += strlen(name) + 1)
   // PUts_trim_cr(name);
   // size = sizeof(struct nvram_header) + (int) name - (int) buf;
   // fprintf(stderr, "size: %d bytes (%d left)\n", size, NVRAM_SPACE - size);
                                                                                                        

    if(strcmp(path, "/") != 0)
        return -ENOENT;

    filler(buf, ".", NULL, 0);
    filler(buf, "..", NULL, 0);
// here we have to put the list of files
    filler(buf, "test_file" + 1, NULL, 0);

    return 0;
}

static int nvram_open(const char *path, struct fuse_file_info *fi)
{
	//here we have to check if the file exists
    if(strcmp(path, "filename") != 0)
        return -ENOENT;

    if((fi->flags & 3) != O_RDONLY)
        return -EACCES;

    return 0;
}

static int nvram_read(const char *path, char *buf, size_t size, off_t offset,
                      struct fuse_file_info *fi)
{
    size_t len;
    (void) fi;
    //here we check if the file exists
    if(strcmp(path, "filename") != 0)
        return -ENOENT;

    // here we put the value of the variable
    len = strlen("this is the value");
    if (offset < len) {
        if (offset + size > len)
            size = len - offset;
	//here we copy the content 
        memcpy(buf, "this is the value" + offset, size);
    } else
        size = 0;

    return size;
}

// no write is implemented yet
static struct fuse_operations nvram_oper = {
    .getattr	= nvram_getattr,
    .readdir	= nvram_readdir,
    .open	= nvram_open,
    .read	= nvram_read,
};

int main(int argc, char *argv[])
{
    return fuse_main(argc, argv, &nvram_oper);
}
