#!/usr/bin/perl
use strict;
use warnings;

my $target = shift @ARGV;
my $filename = shift @ARGV;
my $md5sum = shift @ARGV;
my @mirrors;

my $ok;

@ARGV > 0 or die "Syntax: $0 <target dir> <filename> <md5sum> <mirror> [<mirror> ...]\n";

sub download
{
	my $mirror = shift;
	
	open WGET, "wget -t1 --timeout=20 -O- \"$mirror/$filename\" |" or die "Cannot launch wget.\n";
	open MD5SUM, "| md5sum > \"$target/$filename.md5sum\"" or die "Cannot launch md5sum.\n";
	open OUTPUT, "> $target/$filename.dl" or die "Cannot create file $target/$filename.dl: $!\n";
	my $buffer;
	while (read WGET, $buffer, 1048576) {
		print MD5SUM $buffer;
		print OUTPUT $buffer;
	}
	close MD5SUM;
	close WGET;
	close OUTPUT;
	
	if (($? >> 8) != 0 ) {
		print STDERR "Download failed.\n";
		cleanup();
		return;
	}
	
	my $sum = `cat "$target/$filename.md5sum"`;
	$sum =~ /^(\w+)\s+/ or die "Could not generate md5sum\n";
	$sum = $1;
	
	if ($sum ne $md5sum) {
		print STDERR "MD5 sum of the downloaded file does not match - deleting download.\n";
		cleanup();
		return;
	}
	
	unlink "$target/$filename";
	system("mv \"$target/$filename.dl\" \"$target/$filename\"");
	cleanup();
}

sub cleanup
{
	unlink "$target/$filename.dl";
	unlink "$target/$filename.md5sum";
}

foreach my $mirror (@ARGV) {
	if ($mirror =~ /^\@SF\/(.+)$/) {
		my $sfpath = $1;
		open SF, "wget -t1 -q -O- 'https://prdownloads.sourceforge.net/$sfpath/$filename' |";
		while (<SF>) {
			/RADIO NAME=use_default VALUE=(\w+) OnClick="form\.submit\(\)">/ or
			/type="radio" name="use_default" value="(\w+)" onclick="form\.submit\(\)"\/>/ and do {
				push @mirrors, "https://$1.dl.sourceforge.net/sourceforge/$sfpath";
			};
			/<a href="\/.+\?use_mirror=(\w+)"><b>Download/ and do {
				push @mirrors, "https://$1.dl.sourceforge.net/sourceforge/$sfpath";
			};
		}
		push @mirrors, "https://dl.sourceforge.net/sourceforge/$sfpath";
		close SF;
	} elsif ($mirror =~ /^\@GNU\/(.+)$/) {
		my $gnupath = $1;
		push @mirrors, "https://ftp.gnu.org/gnu/$gnupath";
		push @mirrors, "https://ftpmirror.gnu.org/$gnupath";
		push @mirrors, "https://ftp.fau.de/gnu/$gnupath";
		push @mirrors, "https://www.nic.funet.fi/pub/gnu/ftp.gnu.org/pub/gnu/$gnupath";
		push @mirrors, "https://mirror.csclub.uwaterloo.ca/gnu/$gnupath";
	} else {
		push @mirrors, $mirror;
	}
}

push @mirrors, 'http://mbsd.evolvis.org/.Archive/FreeWRT/';

while (!$ok) {
	my $mirror = shift @mirrors;
	$mirror or die "No more mirrors to try - giving up.\n";
	
	download($mirror);
	-f "$target/$filename" and $ok = 1;
}

$SIG{INT} = \&cleanup;

