# invoke ipkg with configuration in $(STAGING_DIR)/etc/ipkg.conf 

ifneq (${PKG_SOURCE_URL},)
ifeq (${PKG_SOURCE},)
PKG_SOURCE:=	${PKG_NAME}-${PKG_VERSION}.tar.gz
endif
endif
ifneq (${PKG_SOURCE},)
DISTFILES?=	${DL_DIR}/${PKG_SOURCE}
endif

WRKDIR?=	${BUILD_DIR}/w-${PKG_NAME}-${PKG_VERSION}-${PKG_RELEASE}
WRKSRC?=	${WRKDIR}/${PKG_NAME}-${PKG_VERSION}
WRKBUILD?=	${WRKSRC}
WRKINST?=	${WRKDIR}/ipkg-install

define PKG_template
IPKG_$(1)=	$(PACKAGE_DIR)/$(2)_$(3)_$(4).ipk
IDIR_$(1)=	$(WRKDIR)/ipkg/$(2)
INFO_$(1)=	$(IPKG_STATE_DIR)/info/$(2).list

ifneq ($(BR2_PACKAGE_$(1)),)
compile-targets: $$(IPKG_$(1))
endif
ifneq ($(DEVELOPER),)
compile-targets: $$(IPKG_$(1))
endif
ifeq ($(BR2_PACKAGE_$(1)),y)
install-targets: $$(INFO_$(1))
endif

IDEPEND_$(1):=	$$(strip $(5))

$$(IDIR_$(1))/CONTROL/control: $(WRKBUILD)/.prepared
	$(SCRIPT_DIR)/make-ipkg-dir.sh $$(IDIR_$(1)) ./ipkg/$(2).control $(3) $(4)
	[ -z "$$(IDEPEND_$(1))" ] || echo "Depends: $$(IDEPEND_$(1))" >>$$(IDIR_$(1))/CONTROL/control
	for file in conffiles preinst postinst prerm postrm; do \
		[ ! -f ./ipkg/$(2).$$$$file ] || cp ./ipkg/$(2).$$$$file $$(IDIR_$(1))/CONTROL/$$$$file; \
	done

$$(IPKG_$(1)): $$(IDIR_$(1))/CONTROL/control $(WRKBUILD)/.built $(PACKAGE_DIR)

$$(INFO_$(1)): $$(IPKG_$(1))
	$(IPKG) install $$(IPKG_$(1))

$(2)-clean:
	rm -f $$(IPKG_$(1))
clean: $(2)-clean
endef


ifneq (${PKG_SOURCE_URL},)
$(DL_DIR)/$(PKG_SOURCE):
	@$(CMD_TRACE) "downloading... "
	$(SCRIPT_DIR)/download.pl "$(DL_DIR)" "$(PKG_SOURCE)" "$(PKG_MD5SUM)" $(PKG_SOURCE_URL) $(MAKE_TRACE) 
endif

ifneq (${DISTFILES}${PKG_SOURCE},)
$(WRKBUILD)/.prepared: ${DISTFILES}
	rm -rf ${WRKSRC} ${WRKBUILD}
	${EXTRACT_CMD}
	[ ! -d ./patches ] || $(PATCH) $(WRKSRC) ./patches
	touch $(WRKBUILD)/.prepared
endif

all: compile

source: ${DISTFILES}
prepare: source
	@[ -f $(WRKBUILD)/.prepared ] || { \
		$(CMD_TRACE) "preparing... "; \
		$(MAKE) $(WRKBUILD)/.prepared $(MAKE_TRACE); \
	}

configure: prepare
	@[ -f $(WRKBUILD)/.configured ] || { \
		$(CMD_TRACE) "configuring... "; \
		$(MAKE) $(WRKBUILD)/.configured $(MAKE_TRACE); \
	}

compile-targets:
compile: configure
	@$(CMD_TRACE) "compiling... " 
	@$(MAKE) compile-targets $(MAKE_TRACE)

install-targets:
install:
	@$(CMD_TRACE) "installing... "
	@$(MAKE) install-targets $(MAKE_TRACE)

$(WRKBUILD)/.configured:
$(WRKBUILD)/.built:

$(PACKAGE_DIR):
	mkdir -p $@

clean-targets:
clean: 
	@$(CMD_TRACE) "cleaning... " 
	@$(MAKE) clean-targets $(MAKE_TRACE)
	rm -rf ${WRKDIR}

.PHONY: all source prepare compile install clean
