#!/bin/sh
#
# This file is part of the FreeWRT project. FreeWRT is copyrighted
# material, please see the LICENCE file in the top-level directory
# or at http://www.freewrt.org/licence for details.
#
# Christian Fischer <spaetzle@freewrt.org>
# Thorsten Glaser <tg@freewrt.org>
#

config() {
	[ x"$1" = x"1" ]
}

what=${0##*/}
case $what in
ifup)
	;;
ifdown)
	;;
*)
	echo "Usage: ifup|ifdown [options]"
	echo "For options see man busybox"
	exit 1
	;;
esac

. /etc/rc.conf
. /etc/network/mfunctions.sh
redirect="2>&-"

if config $FWIFUPDOWN_DEBUG; then
	set -x
	redirect=
fi
[ -e /tmp/.booting ] && redirect="$redirect >/dev/console"

# cleanup ifstate files
rm -rf /tmp/ifupdown/ifstate
mkdir -p /tmp/ifupdown/ifstate

eval IFUPDOWN_ENV= $(grep '^FWIFUPDOWN_' /etc/rc.conf |sed "s/#.*//g") \
    busybox $what $@ $redirect

i=0	# did we print the initialisation message?
j=0	# timeout in seconds
rv=0	# exit status of this script
while sleep 1; do
	if test $j -gt 30; then
		mstate 1
		merr "bridge initialisation timed out"
		rv=1
		break
	fi
	for x in /tmp/ifupdown/ifstate/bridge/*; do
		# any bridges to check?
		test -e "$x" || break 2		# no -> out of both loops
		# print initialisation message, but once only
		test $i = 1 || mprint -n \
		    "Waiting for bridge initialisation to finish"
		i=1
		# check this bridge for its states
		s=ok
		for state in $(brctl showstp ${x##*/} | \
		    fgrep state | sed "s/^.*state//"); do
			test x"$state" = x"forwarding" && continue
			# if only one is not forwarding, wait
			s=no
			break
		done
		test $s = ok || break	# not ok? wait one second
		rm -f $x		# this bridge done, check next ones
	done
	j=$(expr $j + 1)
done
test $i = 0 || {
	mstate $rv
	minfo "took $j seconds"
}

# vim:ts=4
