# This file is part of the FreeWRT project. FreeWRT is copyrighted
# material, please see the LICENCE file in the top-level directory

# parallel port support

$(eval $(call KMOD_template,LP,lp,\
	$(MODULES_DIR)/kernel/drivers/char/lp.ko \
,CONFIG_PRINTER,,60,lp))

$(eval $(call KMOD_template,PPDEV,ppdev,\
	$(MODULES_DIR)/kernel/drivers/char/ppdev.ko \
,CONFIG_PPDEV,,60,ppdev))

$(eval $(call KMOD_template,PARPORT,parport,\
	$(MODULES_DIR)/kernel/drivers/parport/parport.ko \
,CONFIG_PARPORT,,50,parport))

$(eval $(call KMOD_template,PARPORT_SPLINK,parport-splink,\
	$(MODULES_DIR)/kernel/drivers/parport/parport_splink.ko \
,CONFIG_PARPORT_SPLINK,,55,parport_splink))

# Wireless
$(eval $(call KMOD_template,B43,b43,\
	$(MODULES_DIR)/kernel/drivers/net/wireless/broadcom/b43/b43.ko \
,CONFIG_B43,,30,b43))

$(eval $(call KMOD_template,CFG80211,cfg80211,\
	$(MODULES_DIR)/kernel/net/wireless/cfg80211.ko \
,CONFIG_CFG80211,,15,cfg80211))

$(eval $(call KMOD_template,MAC80211,mac80211,\
	$(MODULES_DIR)/kernel/net/mac80211/mac80211.ko \
,CONFIG_MAC80211,,20,mac80211))

# Networking

$(eval $(call KMOD_template,ATM,atm,\
	$(MODULES_DIR)/kernel/net/atm/atm.ko \
	$(MODULES_DIR)/kernel/net/atm/br2684.ko \
,CONFIG_ATM,,50,atm))

$(eval $(call KMOD_template,GRE,gre,\
	$(MODULES_DIR)/kernel/net/ipv4/ip_gre.ko \
,CONFIG_NET_IPGRE))

$(eval $(call KMOD_template,IMQ,imq,\
	$(MODULES_DIR)/kernel/net/ipv4/netfilter/*IMQ*.ko \
	$(MODULES_DIR)/kernel/drivers/net/imq.ko \
))
$(eval $(call KMOD_template,IPIP,ipip,\
	$(MODULES_DIR)/kernel/net/ipv4/ipip.ko \
,CONFIG_NET_IPIP,,60,ipip))

$(eval $(call KMOD_template,IPV6,ipv6,\
	$(MODULES_DIR)/kernel/net/ipv6/ipv6.ko \
,CONFIG_IPV6,,20,ipv6))

$(eval $(call KMOD_template,PPP,ppp,\
	$(MODULES_DIR)/kernel/drivers/net/ppp_async.ko \
	$(MODULES_DIR)/kernel/drivers/net/ppp_generic.ko \
	$(MODULES_DIR)/kernel/drivers/net/slhc.ko \
	$(MODULES_DIR)/kernel/drivers/net/pppox.ko \
,CONFIG_PPP))

$(eval $(call KMOD_template,MPPE,mppe,\
	$(MODULES_DIR)/kernel/drivers/net/ppp_mppe_mppc.ko \
,CONFIG_PPP_MPPE_MPPC))

$(eval $(call KMOD_template,PPPOATM,pppoatm,\
	$(MODULES_DIR)/kernel/net/atm/pppoatm.ko \
,CONFIG_PPPOATM))

$(eval $(call KMOD_template,PPPOE,pppoe,\
	$(MODULES_DIR)/kernel/drivers/net/pppoe.ko \
,CONFIG_PPPOE))

$(eval $(call KMOD_template,SCHED,sched,\
	$(MODULES_DIR)/kernel/net/sched/*.ko \
))

$(eval $(call KMOD_template,TUN,tun,\
	$(MODULES_DIR)/kernel/drivers/net/tun.ko \
,CONFIG_TUN,,20,tun))

# Filtering / Firewalling

$(eval $(call KMOD_template,ARPTABLES,arptables,\
	$(MODULES_DIR)/kernel/net/ipv4/netfilter/arp*.ko \
,CONFIG_IP_NF_ARPTABLES))

$(eval $(call KMOD_template,EBTABLES,ebtables,\
	$(MODULES_DIR)/kernel/net/bridge/netfilter/*.ko \
,CONFIG_BRIDGE_NF_EBTABLES))

$(eval $(call KMOD_template,IPT_CONNTRACK,ipt-conntrack,\
	$(foreach mod,$(IPT_CONNTRACK-m),$(MODULES_DIR)/kernel/net/ipv4/netfilter/$(mod).ko) \
))

$(eval $(call KMOD_template,IPT_EXTRA,ipt-extra,\
	$(foreach mod,$(IPT_EXTRA-m),$(MODULES_DIR)/kernel/net/ipv4/netfilter/$(mod).ko) \
))

$(eval $(call KMOD_template,IPT_FILTER,ipt-filter,\
	$(foreach mod,$(IPT_FILTER-m),$(MODULES_DIR)/kernel/net/ipv4/netfilter/$(mod).ko) \
))

$(eval $(call KMOD_template,IPT_IPOPT,ipt-ipopt,\
	$(foreach mod,$(IPT_IPOPT-m),$(MODULES_DIR)/kernel/net/ipv4/netfilter/$(mod).ko) \
))

$(eval $(call KMOD_template,IPT_IPSEC,ipt-ipsec,\
	$(foreach mod,$(IPT_IPSEC-m),$(MODULES_DIR)/kernel/net/ipv4/netfilter/$(mod).ko) \
))

$(eval $(call KMOD_template,IPT_NAT,ipt-nat,\
	$(foreach mod,$(IPT_NAT-m),$(MODULES_DIR)/kernel/net/ipv4/netfilter/$(mod).ko) \
))

$(eval $(call KMOD_template,IPT_NAT_EXTRA,ipt-nat-extra,\
	$(foreach mod,$(IPT_NAT_EXTRA-m),$(MODULES_DIR)/kernel/net/ipv4/netfilter/$(mod).ko) \
,,,40,$(IPT_NAT_EXTRA-m)))

$(eval $(call KMOD_template,IPT_QUEUE,ipt-queue,\
	$(foreach mod,$(IPT_QUEUE-m),$(MODULES_DIR)/kernel/net/ipv4/netfilter/$(mod).ko) \
))

$(eval $(call KMOD_template,IPT_ULOG,ipt-ulog,\
	$(foreach mod,$(IPT_ULOG-m),$(MODULES_DIR)/kernel/net/ipv4/netfilter/$(mod).ko) \
))

$(eval $(call KMOD_template,IP6TABLES,ip6tables,\
	$(MODULES_DIR)/kernel/net/ipv6/netfilter/ip*.ko \
,CONFIG_IP6_NF_IPTABLES,kmod-ipv6))


# Block devices

$(eval $(call KMOD_template,LOOP,loop,\
    $(MODULES_DIR)/kernel/drivers/block/loop.ko \
,CONFIG_BLK_DEV_LOOP,,20,loop))

$(eval $(call KMOD_template,NBD,nbd,\
    $(MODULES_DIR)/kernel/drivers/block/nbd.ko \
,CONFIG_BLK_DEV_NBD,,20,nbd))

# Crypto modules
$(eval $(call KMOD_template,CRYPTO_ARC4,crypto-arc4,\
	$(MODULES_DIR)/kernel/lib/crypto/libarc4.ko \
,CONFIG_CRYPTO_LIB_ARC4,,10,libarc4))

$(eval $(call KMOD_template,CRYPTO_SHA1,crypto-sha1,\
	$(MODULES_DIR)/kernel/crypto/sha1.ko \
,CONFIG_CRYPTO_SHA1,,10,sha1))

# Filesystems

$(eval $(call KMOD_template,FS_CIFS,fs-cifs,\
	$(MODULES_DIR)/kernel/fs/cifs/cifs.ko \
,CONFIG_CIFS,,30,cifs))

$(eval $(call KMOD_template,FS_MINIX,fs-minix,\
	$(MODULES_DIR)/kernel/fs/minix/*.ko \
,CONFIG_MINIX_FS,,30,minix))

$(eval $(call KMOD_template,FS_EXT2,fs-ext2,\
	$(MODULES_DIR)/kernel/fs/ext2/*.ko \
,CONFIG_EXT2_FS,,30,ext2))

$(eval $(call KMOD_template,FS_EXT3,fs-ext3,\
	$(MODULES_DIR)/kernel/fs/ext3/*.ko \
	$(MODULES_DIR)/kernel/fs/jbd/*.ko \
,CONFIG_EXT3_FS,,30,jbd ext3))

$(eval $(call KMOD_template,FS_HFSPLUS,fs-hfsplus,\
	$(MODULES_DIR)/kernel/fs/hfsplus/*.ko \
,CONFIG_HFSPLUS_FS,,30,hfsplus))

$(eval $(call KMOD_template,FS_NFS,fs-nfs,\
	$(MODULES_DIR)/kernel/fs/lockd/*.ko \
	$(MODULES_DIR)/kernel/fs/nfs/*.ko \
	$(MODULES_DIR)/kernel/net/sunrpc/*.ko \
,CONFIG_NFS_FS,,30,sunrpc lockd nfs))

$(eval $(call KMOD_template,FS_NFSD,fs-nfsd,\
	$(MODULES_DIR)/kernel/fs/nfsd/nfsd.ko \
,CONFIG_NFSD,,30,nfsd))

$(eval $(call KMOD_template,FS_VFAT,fs-vfat,\
	$(MODULES_DIR)/kernel/fs/vfat/vfat.ko \
	$(MODULES_DIR)/kernel/fs/fat/fat.ko \
,CONFIG_VFAT_FS,,30,fat vfat))

$(eval $(call KMOD_template,FS_XFS,fs-xfs,\
	$(MODULES_DIR)/kernel/fs/xfs/*.ko \
,CONFIG_XFS_FS,,30,xfs))


# Multimedia

$(eval $(call KMOD_template,PWC,pwc,\
	$(MODULES_DIR)/kernel/drivers/usb/pwc.ko \
,CONFIG_USB_PWC,kmod-videodev,63,pwc))

$(eval $(call KMOD_template,SOUNDCORE,soundcore,\
	$(MODULES_DIR)/kernel/drivers/sound/soundcore.ko \
,CONFIG_SOUND,,30,soundcore))

$(eval $(call KMOD_template,VIDEODEV,videodev,\
	$(MODULES_DIR)/kernel/drivers/media/video/videodev.ko \
,CONFIG_VIDEO_DEV,,62,videodev))


# PCMCIA/CardBus

$(eval $(call KMOD_template,PCMCIA_CORE,pcmcia-core,\
	$(MODULES_DIR)/kernel/drivers/pcmcia/pcmcia_core.ko \
	$(MODULES_DIR)/kernel/drivers/pcmcia/yenta_socket.ko \
	$(MODULES_DIR)/kernel/drivers/pcmcia/ds.ko \
,CONFIG_PCMCIA,,50,pcmcia_core yenta_socket ds))

$(eval $(call KMOD_template,PCMCIA_SERIAL,pcmcia-serial,\
	$(MODULES_DIR)/kernel/drivers/char/pcmcia/serial_cs.ko \
,CONFIG_PCMCIA_SERIAL_CS,kmod-pcmcia-core,51,serial_cs))

$(eval $(call KMOD_template,PCMCIA_HSO,pcmcia-hso,\
	$(MODULES_DIR)/kernel/drivers/char/pcmcia/hso/hso.ko \
,CONFIG_PCMCIA,kmod-pcmcia-core,51,hso))


# USB

$(eval $(call KMOD_template,USB,usb-core,\
	$(MODULES_DIR)/kernel/drivers/usb/usbcore.ko \
,CONFIG_USB,,50,usbcore))

$(eval $(call KMOD_template,USB_UHCI,usb-uhci,\
	$(MODULES_DIR)/kernel/drivers/usb/host/uhci.ko \
,CONFIG_USB_UHCI_ALT,kmod-usb-core,60,uhci))

$(eval $(call KMOD_template,USB_OHCI,usb-ohci,\
	$(MODULES_DIR)/kernel/drivers/usb/host/usb-ohci.ko \
,CONFIG_USB_OHCI,kmod-usb-core,60,usb-ohci))

$(eval $(call KMOD_template,USB2,usb2,\
	$(MODULES_DIR)/kernel/drivers/usb/host/ehci-hcd.ko \
,CONFIG_USB_EHCI_HCD,kmod-usb-core,60,ehci-hcd))

$(eval $(call KMOD_template,USB_ACM,usb-acm,\
	$(MODULES_DIR)/kernel/drivers/usb/acm.ko \
,CONFIG_USB_ACM))

$(eval $(call KMOD_template,USB_AUDIO,usb-audio,\
	$(MODULES_DIR)/kernel/drivers/usb/audio.ko \
,CONFIG_USB_AUDIO,kmod-soundcore kmod-usb-core,61,audio))

$(eval $(call KMOD_template,USB_PRINTER,usb-printer,\
	$(MODULES_DIR)/kernel/drivers/usb/printer.ko \
,CONFIG_USB_PRINTER,kmod-usb-core,60,printer))

$(eval $(call KMOD_template,USB_SERIAL,usb-serial,\
	$(MODULES_DIR)/kernel/drivers/usb/serial/usbserial.ko \
,CONFIG_USB_SERIAL,kmod-usb-core,60,usbserial))

$(eval $(call KMOD_template,USB_SERIAL_BELKIN,usb-serial-belkin,\
	$(MODULES_DIR)/kernel/drivers/usb/serial/belkin_sa.ko \
,CONFIG_USB_SERIAL_BELKIN,kmod-usb-serial,61,belkin_sa))

$(eval $(call KMOD_template,USB_SERIAL_FTDI,usb-serial-ftdi,\
	$(MODULES_DIR)/kernel/drivers/usb/serial/ftdi_sio.ko \
,CONFIG_USB_SERIAL_FTDI_SIO,kmod-usb-serial,61,ftdi_sio))

$(eval $(call KMOD_template,USB_SERIAL_MCT_U232,usb-serial-mct-u232,\
	$(MODULES_DIR)/kernel/drivers/usb/serial/mct_u232.ko \
,CONFIG_USB_SERIAL_MCT_U232,kmod-usb-serial,61,mct_u232))

$(eval $(call KMOD_template,USB_SERIAL_PL2303,usb-serial-pl2303,\
	$(MODULES_DIR)/kernel/drivers/usb/serial/pl2303.ko \
,CONFIG_USB_SERIAL_PL2303,kmod-usb-serial,61,pl2303))

$(eval $(call KMOD_template,USB_SERIAL_VISOR,usb-serial-visor,\
	$(MODULES_DIR)/kernel/drivers/usb/serial/visor.ko \
,CONFIG_USB_SERIAL_VISOR,kmod-usb-serial,61,visor))

$(eval $(call KMOD_template,USB_STORAGE,usb-storage,\
	$(MODULES_DIR)/kernel/drivers/scsi/*.ko \
	$(MODULES_DIR)/kernel/drivers/usb/storage/*.ko \
,CONFIG_USB_STORAGE,kmod-usb-core,60,scsi_mod sd_mod usb-storage))


# Misc. devices

$(eval $(call KMOD_template,AX25,ax25,\
	$(MODULES_DIR)/kernel/net/ax25/ax25.ko \
	$(MODULES_DIR)/kernel/drivers/net/hamradio/mkiss.ko \
,CONFIG_AX25,,90,ax25 mkiss))

$(eval $(call KMOD_template,BLUETOOTH,bluetooth,\
	$(MODULES_DIR)/kernel/net/bluetooth/*.ko \
	$(MODULES_DIR)/kernel/net/bluetooth/bnep/bnep.ko \
	$(MODULES_DIR)/kernel/net/bluetooth/rfcomm/*.ko \
	$(MODULES_DIR)/kernel/drivers/bluetooth/*.ko \
,CONFIG_BLUEZ,,90,bluez l2cap hci_usb hci_uart sco rfcomm bnep))

$(eval $(call KMOD_template,SOFTDOG,softdog,\
	$(MODULES_DIR)/kernel/drivers/char/softdog.ko \
,CONFIG_SOFT_WATCHDOG,,95,softdog))

# NLS

$(eval $(call KMOD_template,NLS_CP437,nls-cp437,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp437.ko \
,CONFIG_NLS_CODEPAGE_437,kmod-nls-cp437,80,nls_cp437))

$(eval $(call KMOD_template,NLS_CP737,nls-cp737,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp737.ko \
,CONFIG_NLS_CODEPAGE_737,kmod-nls-cp737,80,nls_cp737))

$(eval $(call KMOD_template,NLS_CP775,nls-cp775,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp775.ko \
,CONFIG_NLS_CODEPAGE_775,kmod-nls-cp775,80,nls_cp775))

$(eval $(call KMOD_template,NLS_CP850,nls-cp850,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp850.ko \
,CONFIG_NLS_CODEPAGE_850,kmod-nls-cp850,80,nls_cp850))

$(eval $(call KMOD_template,NLS_CP852,nls-cp852,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp852.ko \
,CONFIG_NLS_CODEPAGE_852,kmod-nls-cp852,80,nls_cp852))

$(eval $(call KMOD_template,NLS_CP857,nls-cp857,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp857.ko \
,CONFIG_NLS_CODEPAGE_857,kmod-nls-cp857,80,nls_cp857))

$(eval $(call KMOD_template,NLS_CP860,nls-cp860,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp860.ko \
,CONFIG_NLS_CODEPAGE_860,kmod-nls-cp860,80,nls_cp860))

$(eval $(call KMOD_template,NLS_CP861,nls-cp861,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp861.ko \
,CONFIG_NLS_CODEPAGE_861,kmod-nls-cp861,80,nls_cp861))

$(eval $(call KMOD_template,NLS_CP862,nls-cp862,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp862.ko \
,CONFIG_NLS_CODEPAGE_862,kmod-nls-cp862,80,nls_cp862))

$(eval $(call KMOD_template,NLS_CP863,nls-cp863,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp863.ko \
,CONFIG_NLS_CODEPAGE_863,kmod-nls-cp863,80,nls_cp863))

$(eval $(call KMOD_template,NLS_CP864,nls-cp864,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp864.ko \
,CONFIG_NLS_CODEPAGE_864,kmod-nls-cp864,80,nls_cp864))

$(eval $(call KMOD_template,NLS_CP865,nls-cp865,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp865.ko \
,CONFIG_NLS_CODEPAGE_865,kmod-nls-cp865,80,nls_cp865))

$(eval $(call KMOD_template,NLS_CP866,nls-cp866,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp866.ko \
,CONFIG_NLS_CODEPAGE_866,kmod-nls-cp866,80,nls_cp866))

$(eval $(call KMOD_template,NLS_CP869,nls-cp869,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp869.ko \
,CONFIG_NLS_CODEPAGE_869,kmod-nls-cp869,80,nls_cp869))

$(eval $(call KMOD_template,NLS_CP874,nls-cp874,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp874.ko \
	$(MODULES_DIR)/kernel/fs/nls/nls_tis-620.ko \
,CONFIG_NLS_CODEPAGE_874,kmod-nls-cp874,80,nls_cp874 nls_tis-620))

$(eval $(call KMOD_template,NLS_CP932,nls-cp932,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp932.ko \
	$(MODULES_DIR)/kernel/fs/nls/nls_sjis.ko \
	$(MODULES_DIR)/kernel/fs/nls/nls_euc-jp.ko \
,CONFIG_NLS_CODEPAGE_932,kmod-nls-cp932,80,nls_cp932 nls_sjis nls_euc-jp))

$(eval $(call KMOD_template,NLS_CP936,nls-cp936,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp936.ko \
	$(MODULES_DIR)/kernel/fs/nls/nls_gb2312.ko \
,CONFIG_NLS_CODEPAGE_936,kmod-nls-cp936,80,nls_cp936 nls_gb2312))

$(eval $(call KMOD_template,NLS_CP949,nls-cp949,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp949.ko \
	$(MODULES_DIR)/kernel/fs/nls/nls_euc-kr.ko \
,CONFIG_NLS_CODEPAGE_949,kmod-nls-cp949,80,nls_cp949 nls_euc-kr))

$(eval $(call KMOD_template,NLS_CP950,nls-cp950,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp950.ko \
	$(MODULES_DIR)/kernel/fs/nls/nls_big5.ko \
,CONFIG_NLS_CODEPAGE_950,kmod-nls-cp950,80,nls_cp950 nls_big5))

$(eval $(call KMOD_template,NLS_CP1250,nls-cp1250,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp1250.ko \
,CONFIG_NLS_CODEPAGE_1250,kmod-nls-cp1250,80,nls_cp1250))

$(eval $(call KMOD_template,NLS_CP1251,nls-cp1251,\
	$(MODULES_DIR)/kernel/fs/nls/nls_cp1251.ko \
,CONFIG_NLS_CODEPAGE_1251,kmod-nls-cp1251,80,nls_cp1251))

$(eval $(call KMOD_template,NLS_ISO8859_1,nls-iso8859-1, \
	$(MODULES_DIR)/kernel/fs/nls/nls_iso8859-1.ko \
,CONFIG_NLS_ISO8859_1,kmod-nls-iso8859-1,80,nls_iso8859-1))

$(eval $(call KMOD_template,NLS_ISO8859_2,nls-iso8859-2, \
	$(MODULES_DIR)/kernel/fs/nls/nls_iso8859-2.ko \
,CONFIG_NLS_ISO8859_2,kmod-nls-iso8859-2,80,nls_iso8859-2))

$(eval $(call KMOD_template,NLS_ISO8859_3,nls-iso8859-3, \
	$(MODULES_DIR)/kernel/fs/nls/nls_iso8859-3.ko \
,CONFIG_NLS_ISO8859_3,kmod-nls-iso8859-3,80,nls_iso8859-3))

$(eval $(call KMOD_template,NLS_ISO8859_4,nls-iso8859-4, \
	$(MODULES_DIR)/kernel/fs/nls/nls_iso8859-4.ko \
,CONFIG_NLS_ISO8859_4,kmod-nls-iso8859-4,80,nls_iso8859-4))

$(eval $(call KMOD_template,NLS_ISO8859_5,nls-iso8859-5, \
	$(MODULES_DIR)/kernel/fs/nls/nls_iso8859-5.ko \
,CONFIG_NLS_ISO8859_5,kmod-nls-iso8859-5,80,nls_iso8859-5))

$(eval $(call KMOD_template,NLS_ISO8859_6,nls-iso8859-6, \
	$(MODULES_DIR)/kernel/fs/nls/nls_iso8859-6.ko \
,CONFIG_NLS_ISO8859_6,kmod-nls-iso8859-6,80,nls_iso8859-6))

$(eval $(call KMOD_template,NLS_ISO8859_7,nls-iso8859-7, \
	$(MODULES_DIR)/kernel/fs/nls/nls_iso8859-7.ko \
,CONFIG_NLS_ISO8859_7,kmod-nls-iso8859-7,80,nls_iso8859-7))

$(eval $(call KMOD_template,NLS_ISO8859_8,nls-iso8859-8, \
	$(MODULES_DIR)/kernel/fs/nls/nls_iso8859-8.ko \
	$(MODULES_DIR)/kernel/fs/nls/nls_cp1255.ko \
,CONFIG_NLS_ISO8859_8,kmod-nls-iso8859-8,80,nls_iso8859-8 nls_cp1255))

$(eval $(call KMOD_template,NLS_ISO8859_9,nls-iso8859-9, \
	$(MODULES_DIR)/kernel/fs/nls/nls_iso8859-9.ko \
,CONFIG_NLS_ISO8859_9,kmod-nls-iso8859-9,80,nls_iso8859-9))

$(eval $(call KMOD_template,NLS_ISO8859_13,nls-iso8859-13, \
	$(MODULES_DIR)/kernel/fs/nls/nls_iso8859-13.ko \
,CONFIG_NLS_ISO8859_13,kmod-nls-iso8859-13,80,nls_iso8859-13))

$(eval $(call KMOD_template,NLS_ISO8859_14,nls-iso8859-14, \
	$(MODULES_DIR)/kernel/fs/nls/nls_iso8859-14.ko \
,CONFIG_NLS_ISO8859_14,kmod-nls-iso8859-14,80,nls_iso8859-14))

$(eval $(call KMOD_template,NLS_ISO8859_15,nls-iso8859-15, \
	$(MODULES_DIR)/kernel/fs/nls/nls_iso8859-15.ko \
,CONFIG_NLS_ISO8859_15,kmod-nls-iso8859-15,80,nls_iso8859-15))

$(eval $(call KMOD_template,NLS_KOI8_R,nls-koi8-r, \
	$(MODULES_DIR)/kernel/fs/nls/nls_koi8-r.ko \
,CONFIG_NLS_KOI8_R,kmod-nls-koi8-r,80,nls_koi8-r))

$(eval $(call KMOD_template,NLS_KOI8_U,nls-koi8-u, \
	$(MODULES_DIR)/kernel/fs/nls/nls_koi8-u.ko \
	$(MODULES_DIR)/kernel/fs/nls/nls_koi8-ru.ko \
,CONFIG_NLS_KOI8_U,kmod-nls-koi8-u,80,nls_koi8-u nls_koi8-ru))

$(eval $(call KMOD_template,NLS_UTF8,nls-utf8, \
	$(MODULES_DIR)/kernel/fs/nls/nls_utf8.ko \
,CONFIG_NLS_UTF8,kmod-nls-utf8,80,nls_utf8))
