# $FreeWRT: src/share/misc/licence.template,v 1.20 2006/12/11 21:04:56 tg Rel $
#-
# Copyright (c) 2006, 2007
#	Thorsten Glaser <tg@mirbsd.de>
#
# Provided that these terms and disclaimer and all copyright notices
# are retained or reproduced in an accompanying document, permission
# is granted to deal in this work without restriction, including un-
# limited rights to use, publicly perform, distribute, sell, modify,
# merge, give away, or sublicence.
#
# Advertising materials mentioning features or use of this work must
# display the following acknowledgement:
#	This product includes material provided by Thorsten Glaser.
# This acknowledgement does not need to be reprinted if this work is
# linked into a bigger work whose licence does not allow such clause
# and the author of this work is given due credit in the bigger work
# or its accompanying documents, where such information is generally
# kept, provided that said credits are retained.
#
# This work is provided "AS IS" and WITHOUT WARRANTY of any kind, to
# the utmost extent permitted by applicable law, neither express nor
# implied; without malicious intent or gross negligence. In no event
# may a licensor, author or contributor be held liable for indirect,
# direct, other damage, loss, or other issues arising in any way out
# of dealing in the work, even if advised of the possibility of such
# damage or existence of a defect, except proven that it results out
# of said person's immediate fault when using the work as intended.
#-
# Scan for prerequisite host tools.

if test -z "$BASH_VERSION"; then
	echo FreeWRT requires GNU bash to be installed, sorry.
	exit 1
fi

shopt -s extglob
topdir=$(pwd)
opath=$PATH
out=0
bmake=

if [[ $NO_ERROR != @(0|1) ]]; then
	echo Please do not invoke this script directly!
	exit 1
fi

set -e
rm -rf $topdir/lbin/tmp
mkdir -p $topdir/lbin/tmp
cd $topdir/lbin/tmp

rm -f foo
echo >FOO
if [[ -e foo ]]; then
	cat >&2 <<-EOF
		ERROR: FreeWRT cannot be built in a case-insensitive
		file system. Please use scripts/darwindiskimage on a
		Macintosh to create a case-sensitive filesystem image,
		or reconfigure your Windows system approprately.
	EOF
	exit 1
fi
rm -f FOO

os=$(uname)
case $os in
Darwin)
	# needs a bunch of quirks, but seems to compile
	echo Warning: Darwin support is highly experimental.
	echo
	;;
Linux)
	# supported with no extra quirks at the moment
	;;
OpenBSD)
	# supported with no extra quirks at the moment
	# although some packages' autoconf scripts may
	# not properly recognise OpenBSD
	;;
MirBSD)
	# needs a little quirk, because the autoconf
	# version of some packages doesn't recognise
	# it as valid OS, and as build (not host) OS
	# faking OpenBSD is close enough
	rm -f $topdir/lbin/uname
	sed -e 's!@@FromOS@@!MirBSD!g' -e 's!@@ToOS@@!OpenBSD!g' \
	    -e "s!@@PROG@@!$($topdir/lbin/which uname)!g" \
	    <$topdir/scripts/uname.fake >$topdir/lbin/uname
	chmod 555 $topdir/lbin/uname
	bmake=/usr/bin/make
	;;
*)
	# unsupported
	echo "Building FreeWRT on $os is currently unsupported."
	echo "Sorry."
	echo
	case $os in
	Cyg*)
		echo "The most prominent issue is that filesystems"
		echo "can be case-insensitive. Some macros are missing."
		echo
		;;
	NetBSD|FreeBSD|DragonFly)
		echo "Building should succeed with relatively few"
		echo "patches, but perl must live in /usr/bin for"
		echo "now in FreeWRT, which should indeed be fixed."
		echo
		;;
	esac
	echo "If you need FreeWRT building on $os, please contact"
	echo "the development team; there may be contractors available"
	echo "for this task. If you intend on turning $os into one of"
	echo "the supported build OSes, please contact us as well so"
	echo "that we can feed back your enhancements into FreeWRT."
	exit 1
	;;
esac

set +e

if [[ ! -e $topdir/lbin/gmake ]]; then
	for f in $topdir/tools_build/gmake/make \
	    "$($topdir/lbin/which gmake)" "$($topdir/lbin/which make)"; do
		[[ -e $f ]] || continue
		if [[ $f = $topdir/tools_build/gmake/make ]]; then
			install -c -s -m 555 $f $topdir/lbin/gmake
		else
			ln -s "$f" $topdir/lbin/gmake
		fi
		break
	done
fi
X=$($topdir/lbin/gmake --version 2>&1 | grep '^GNU Make' | \
    sed -e 's/GNU Make //' -e 's/version //' -e 's/, by.*$//')
[[ $X = +([0-9]).+([0-9]).+([0-9]) ]] && X=${X%.*}
if [[ $X = +([0-9]).+([0-9]) ]]; then
	let major=${X%.*}
	let minor=${X#*.}
elif [[ $X = +([0-9]).+([0-9])beta* ]]; then
	# Beta version is not "the real thing"
	let major=${X%.*}
	X=${X%beta*}
	let minor=${X#*.}-1
else
	let major=0
fi
if (( (major < 3) || ((major == 3) && (minor < 81)) )); then
	echo "---> building GNU make 3.81"
	rm -rf $topdir/tools_build/gmake $topdir/lbin/gmake
	set -e
	mkdir -p $topdir/tools_build/gmake
	cd $topdir/tools_build/gmake
	env CPPFLAGS="$CPPFLAGS -Dstrcmpi=strcasecmp" \
	    CFLAGS="$(grep '^HOSTCFLAGS' $topdir/lbin/prereq.mk | \
		sed 's/HOSTCFLAGS:=//')" \
	    $BASH $topdir/tools/gmake/configure \
	    --program-prefix=g \
	    --disable-dependency-tracking \
	    --disable-nls \
	    --without-libiconv-prefix \
	    --without-libintl-prefix
	make all
	install -c -s -m 555 make $topdir/lbin/gmake
	set +e
	cd $topdir/lbin; ls -l gmake
	cd $topdir/lbin/tmp
fi
export PATH=$topdir/lbin:$PATH

cat >Makefile <<'EOF'
include ${TOPDIR}/lbin/prereq.mk
HOSTCFLAGS+=	${FLAG_TEST}
all: run-test

test: test.c
	${HOSTCC} ${HOSTCFLAGS} -o $@ $^ ${LDADD}

run-test: test
	./test
EOF
cat >test.c <<-'EOF'
	#include <stdio.h>
	int
	main()
	{
		printf("Yay! Native compiler works.\n");
		return (0);
	}
EOF
X=$(gmake TOPDIR=$topdir 2>&1)
if [[ $X != *@(Native compiler works)* ]]; then
	echo "$X" | sed 's/^/| /'
	echo Cannot compile a simple test programme.
	echo You must install a host make and C compiler,
	echo usually GCC, to proceed.
	echo
	out=1
fi
rm test

X=$(gmake FLAG_TEST=-fwrapv TOPDIR=$topdir 2>&1)
grep '^HOSTCFLAGS.*-fwrapv' ../prereq.mk >/dev/null 2>&1 || \
    if [[ $X = *@(Native compiler works)* ]]; then
	printf '/^HOSTCFLAGS/s/$/ -fwrapv/\nwq\n' | ed -s ../prereq.mk
else
	echo "$X" | sed 's/^/| /'
fi
rm test

need_fnotreevrp=0
X=$(gmake FLAG_TEST=-fno-tree-vrp TOPDIR=$topdir 2>&1)
grep '^HOSTCFLAGS.*-fno-tree-vrp' ../prereq.mk >/dev/null 2>&1 || \
    if [[ $X = *@(Native compiler works)* ]]; then
	need_fnotreevrp=1
else
	#echo "$X" | sed 's/^/| /'
	:
fi
rm test*
if [[ $need_fnotreevrp = 1 ]]; then
	cat >test.c <<-'EOF'
		typedef unsigned size_t;
		char *strncpy(char *, const char *, size_t);
		char *
		strncpy(char *d, const char *s, size_t n)
		{
			if (!d || !s) {
				if (d)
					*d = n;
				return (d);
			}
			return (*d = 1, d);
		}
		int
		main(void)
		{
			char a[] = "t";
			strncpy(a, (void *)0, 2);
			return (*a);
		}
	EOF
	X=$(gmake test TOPDIR=$topdir 2>&1)
	if [[ -x test ]]; then
		./test >/dev/null 2>&1
		[[ $? = 2 ]] && need_fnotreevrp=0
	fi
	rm test*
fi
[[ $need_fnotreevrp = 1 ]] && \
    printf '/^HOSTCFLAGS/s/$/ -fno-tree-vrp/\nwq\n' | ed -s ../prereq.mk

if ! which flex >/dev/null 2>&1; then
	echo You must install flex to continue.
	echo
	out=1
else
	echo '%%' | flex -
	if fgrep _POSIX_SOURCE lex.yy.c; then
		echo Your lexer \(flex\) contains a broken skeleton.
		if [[ $NO_ERROR = 1 ]]; then
			echo WARNING: continue at your own risk.
			echo Some packages may be broken.
		else
			echo You can continue the build by issuing \'make prereq-noerror\'
			echo However, several packages may faild to build correctly.
			out=1
		fi
		echo
	fi
fi

if ! which bison >/dev/null 2>&1; then
	echo You must install GNU Bison to continue.
	echo While you can install any version, it is '*STRONGLY*' suggested
	echo to install GNU Bison version 2.3 because of its bug fixes.
	echo
	out=1
fi
X=$(bison --version 2>&1 | fgrep 'GNU Bison' | sed 's/^[^0-9]*//')
V=old
if [[ $X = +([0-9]).+([0-9]) ]]; then
	let major=${X%.*}
	let minor=${X#*.}
	if (( (major > 2) || ((major == 2) && (minor >= 3)) )); then
		V=new
	fi
fi
if [[ $V = old ]]; then
	echo It is suggested to upgrade your copy of bison to
	echo GNU Bison 2.3 because of its bug fixes.
fi

if ! which gzip >/dev/null 2>&1; then
	echo You must install gzip to continue.
	echo
	out=1
fi

if ! which bzip2 >/dev/null 2>&1; then
	echo You must install bzip2 to continue.
	echo
	out=1
fi

if ! which unzip >/dev/null 2>&1; then
	echo You must install unzip to continue, sorry.
	echo
	out=1
fi

if ! which zip >/dev/null 2>&1; then
	echo You must install zip to continue, sorry.
	echo
	out=1
fi

if ! which patch >/dev/null 2>&1; then
	echo You must install patch \(from Larry Wall\) to continue.
	echo
	out=1
fi

cat >test.c <<-'EOF'
	#include <stdio.h>
	#include <zlib.h>

	#ifndef STDIN_FILENO
	#define STDIN_FILENO 0
	#endif

	int
	main()
	{
		gzFile zstdin;
		char buf[1024];
		int i;

		zstdin = gzdopen(STDIN_FILENO, "rb");
		i = gzread(zstdin, buf, sizeof (buf));
		if ((i > 0) && (i < sizeof (buf)))
			buf[i] = '\0';
		buf[sizeof (buf) - 1] = '\0';
		printf("%s\n", buf);
		return (0);
	}
EOF
X=$(echo 'Yay! Native compiler works.' | gzip | \
    gmake TOPDIR=$topdir LDADD=-lz 2>&1)
if [[ $X != *@(Native compiler works)* ]]; then
	echo "$X" | sed 's/^/| /'
	echo Cannot compile a libz test programme.
	echo You must install the zlib development package,
	echo usually called libz-dev, and the run-time library.
	echo
	out=1
fi

if [[ ! -s /usr/include/ncurses.h ]]; then
	echo Install ncurses header files, please.
	echo
	out=1
fi

if ! which g++ >/dev/null 2>&1; then
	echo You must install the host GNU C++ compiler to continue.
	echo
	out=1
fi

#if ! which perl >/dev/null 2>&1; then
if [[ "$(which perl 2>/dev/null)" != /usr/bin/perl ]]; then
	echo You must install Perl in /usr/bin to continue.
	echo
	out=1
fi

if ! which wget >/dev/null 2>&1; then
	echo You must install GNU wget to continue.
	echo
	out=1
fi

if ! which makeinfo >/dev/null 2>&1; then
	echo You must install GNU texinfo to continue.
	echo
	out=1
fi

if ! which ed >/dev/null 2>&1; then
	echo Why does your distribution not package the standard
	echo text editor, ed? Please install it to continue.
	echo
	out=1
elif [[ "$(PATH=/bin:$PATH which ed 2>/dev/null)" != /bin/ed ]]; then
	echo Your operating system installs ed, the standard text
	echo editor, not as /bin/ed. While you can build FreeWRT
	echo with this, ask your vendor to fix it, point to the
	echo FHS if needed.
	echo
fi

if ! which file >/dev/null 2>&1; then
	echo You must install \"file\" to continue.
	echo
	out=1
fi

have_tsort=0
if which tsort >/dev/null 2>&1; then
	v=$(printf 'a b\nb c\n' | tsort -r 2>/dev/null | md5sum)
	[[ ${v%% *} = 0617bc44e824dd65da71d04b29c85e63 ]] && have_tsort=1
fi

if [[ $have_tsort = 0 ]]; then
	bmake=
else
	for x in $bmake $(which mmake) $(which bmake) /usr/bin/make; do
		bmake=
		y=$(printf 't:\n\t@echo ${_MIRMAKE_VER}\n' | \
		    $x -f - t 2>/dev/null)
		[[ $y = +([0-9]) ]] || continue
		[[ $y < 20070626 ]] && continue
		bmake=$x
		break
	done
fi
[[ $bmake = $topdir/lbin/bmake ]] && bmake=

if [[ $have_tsort = 0 || -z $bmake ]]; then
	echo USE_TOOLS_MIRMAKE=1 >>$topdir/lbin/prereq.mk
	bmake=$topdir/lbin/bmake
	if ! which mksh >/dev/null 2>&1; then
		echo USE_TOOLS_MKSH=1 >>$topdir/lbin/prereq.mk
	fi
fi

echo "BMAKE='$bmake'" >>$topdir/lbin/prereq.mk


cd $topdir
rm -rf lbin/tmp

# populate some more tools
cat >lbin/autoconf <<-EOF
	#!$BASH
	echo '===> Warning: this package calls autoconf!'
	exit 0
EOF
cp lbin/autoconf lbin/autoheader
for v in 2.13 2.52 2.53 2.54 2.55 2.56 2.57 2.58 2.59 2.60 2.61; do
	cp lbin/autoconf lbin/autoconf-$v
	cp lbin/autoconf lbin/autoheader-$v
done
cat >lbin/automake <<-EOF
	#!$BASH
	echo '===> Warning: this package calls automake!'
	exit 0
EOF
cp lbin/automake lbin/aclocal
for v in 1.4 1.5 1.6 1.7 1.8 1.9 1.10; do
	cp lbin/automake lbin/automake-$v
	cp lbin/automake lbin/aclocal-$v
done
chmod a+x lbin/{autoconf,autoheader,automake,aclocal}*

exit $out
