#!/usr/bin/webif-page
<? 
. /usr/lib/webif/webif.sh
load_settings network
load_settings dhcp

FORM_dns="${lan_dns:-$(nvram get lan_dns)}"
LISTVAL="$FORM_dns"
handle_list "$FORM_dnsremove" "$FORM_dnsadd" "$FORM_dnssubmit" 'ip|FORM_dnsadd|@TR<<DNS Address>>|required' && {
	FORM_dns="$LISTVAL"
	save_setting network lan_dns "$FORM_dns"
}
FORM_dnsadd=${FORM_dnsadd:-192.168.1.1}

if empty "$FORM_submit"; then
	FORM_lan_ipaddr=${lan_ipaddr:-$(nvram get lan_ipaddr)}
	FORM_lan_netmask=${lan_netmask:-$(nvram get lan_netmask)}
	FORM_lan_gateway=${lan_gateway:-$(nvram get lan_gateway)}
	FORM_dhcp_enabled=${dhcp_enabled:-$(nvram get dhcp_enabled)}
	FORM_dhcp_start=${dhcp_start:-$(nvram get dhcp_start)}
	FORM_dhcp_num=${dhcp_num:-$(nvram get dhcp_num)}
	eval $(ipcalc $FORM_lan_ipaddr $FORM_lan_netmask $FORM_dhcp_start $FORM_dhcp_num)
	FORM_dhcp_end=$END
else 
	SAVED=1
	validate <<EOF
ip|FORM_lan_ipaddr|@TR<<IP Address>>|required|$FORM_lan_ipaddr
netmask|FORM_lan_netmask|@TR<<Netmask>>|required|$FORM_lan_netmask
ip|FORM_lan_gateway|@TR<<Gateway>>||$FORM_lan_gateway
ip|FORM_dhcp_start|@TR<<First IP Address>>||$FORM_dhcp_start
ip|FORM_dhcp_end|@TR<<Last IP Address>>||$FORM_dhcp_end
EOF

	equal "$?" 0 && {
		save_setting network lan_ipaddr $FORM_lan_ipaddr
		save_setting network lan_netmask $FORM_lan_netmask
		save_setting network lan_gateway $FORM_lan_gateway
		save_setting dhcp dhcp_enabled $FORM_dhcp_enabled
		FORM_dhcp_num=$(
awk -f /usr/lib/webif/common.awk -f - $FORM_dhcp_start $FORM_dhcp_end <<EOF
BEGIN	{
	ipstart=ip2int(ARGV[1])
	ipend=ip2int(ARGV[2])
	printf ipend - ipstart + 1
	}
EOF
)
		save_setting dhcp dhcp_start $FORM_dhcp_start
		save_setting dhcp dhcp_num $FORM_dhcp_num
	}
fi


header "Network" "LAN" "@TR<<LAN Configuration>>" '' "$SCRIPT_NAME"

exists /usr/sbin/dnsmasq && DHCP_FORM="
	field|@TR<<DHCP Server>>
	select|dhcp_enabled|$FORM_dhcp_enabled
	option|0|@TR<<Disabled>>
	option|1|@TR<<Enabled>>
	field|@TR<<First IP Address>>
	text|dhcp_start|$FORM_dhcp_start
	field|@TR<<Last IP Address>>
	text|dhcp_end|$FORM_dhcp_end
" || DHCP_FORM="
	field|@TR<<Package \"dnsmasq\" not installed.>>
	string|<a href=\"ipkg.sh?action=install&amp;pkg=dnsmasq\">Install now.</a>
"

display_form <<EOF
start_form|@TR<<LAN Configuration>>
	field|@TR<<IP Address>>
	text|lan_ipaddr|$FORM_lan_ipaddr
	field|@TR<<Netmask>>
	text|lan_netmask|$FORM_lan_netmask
	field|@TR<<Default Gateway>>
	text|lan_gateway|$FORM_lan_gateway
end_form

start_form|@TR<<DHCP Configuration>>
$DHCP_FORM
end_form

start_form|@TR<<DNS Servers>>
	listedit|dns|$SCRIPT_NAME?|$FORM_dns|$FORM_dnsadd
	helpitem|Note
	helptext|Helptext DNS save#You need save your settings on this page before adding/removing DNS servers
end_form
EOF

footer ?>
<!--
##WEBIF:name:Network:1:LAN
-->
