# $FreeWRT$

include $(TOPDIR)/lbin/prereq.mk
export BASH HOSTCC HOSTCFLAGS LC_ALL MAKE OStype PATH
include $(TOPDIR)/.config

ifeq ($(V),)
V=			5
endif


ifneq ($(V),0)
TRACE:=			echo "---> "
START_TRACE:=		echo -n "---> "
END_TRACE:=		echo
else
START_TRACE:=		:
END_TRACE:=		:
TRACE:=			:
endif

ifeq (${shell [ "$(V)" -ge 5 ] && echo 1},)
CMD_TRACE:=		:
PKG_TRACE:=		:
else
CMD_TRACE:=		echo -n
PKG_TRACE:=		echo "------> "
endif

ifeq (${shell [ "$(V)" -ge 10 ] && echo 1},)
EXTRA_MAKEFLAGS:=	-s
MAKE_TRACE:=		>/dev/null 2>&1 || { echo "Build failed. Please re-run make with V=99 to see what's going on"; false; }
else
MAKE_TRACE:=
EXTRA_MAKEFLAGS:=
TRACE:=			:
PKG_TRACE:=		:
CMD_TRACE:=		:
START_TRACE:=		:
END_TRACE:=		:
endif

ifeq (${shell [ "$(V)" -ge 90 ] && echo 1},)
SET_DASHX:=		:
else
SET_DASHX:=		set -x
endif

CP=			cp -fpR
INSTALL_DIR=		install -d -m0755
INSTALL_DATA=		install -m0644
INSTALL_BIN=		install -m0755
MAKEFLAGS=		-j$(BR2_JLEVEL) V=$(V) $(EXTRA_MAKEFLAGS)
# Strip off the annoying quoting
ARCH:=			$(strip $(subst ",, $(BR2_ARCH)))
WGET:=			$(strip $(subst ",, $(BR2_WGET)))
TARGET_OPTIMIZATION:=	$(strip $(subst ",, $(BR2_TARGET_OPTIMIZATION)))
#"))"))"))"))")) # for vim's broken syntax highlighting :)

TARGET_CFLAGS:=		$(TARGET_OPTIMIZATION) $(TARGET_DEBUGGING)
OPTIMIZE_FOR_CPU=	$(ARCH)

BASE_DIR:=		$(TOPDIR)
DL_DIR:=		$(BASE_DIR)/dl
BUILD_DIR:=		$(BASE_DIR)/build_$(ARCH)$(ARCH_FPU_SUFFIX)
STAGING_DIR:=		$(BASE_DIR)/staging_dir_$(ARCH)$(ARCH_FPU_SUFFIX)
TOOLCHAIN_BUILD_DIR=	$(BASE_DIR)/toolchain_build_$(ARCH)$(ARCH_FPU_SUFFIX)
TOOLCHAIN_STAMP_DIR:=	$(STAGING_DIR)/stamp
TOOLS_DIR=		$(BASE_DIR)/tools
TOOLS_BUILD_DIR=	$(BASE_DIR)/tools_build
TOOLS_STAMP_DIR:=	$(STAGING_DIR)/stamp
SCRIPT_DIR:=		$(BASE_DIR)/scripts
BIN_DIR:=		$(BASE_DIR)/bin
LBIN_DIR:=		$(BASE_DIR)/lbin
PACKAGE_DIR:=		$(BIN_DIR)/packages
STAMP_DIR:=		$(BUILD_DIR)/stamp
TARGET_DIR:=		$(BUILD_DIR)/root
TARGET_PATH=		$(LBIN_DIR):$(STAGING_DIR)/usr/bin:$(STAGING_DIR)/bin:$(_PATH)
IMAGE:=			$(BUILD_DIR)/root_fs_$(ARCH)$(ARCH_FPU_SUFFIX)
REAL_GNU_TARGET_NAME=	$(OPTIMIZE_FOR_CPU)-linux-uclibc
GNU_TARGET_NAME=	$(OPTIMIZE_FOR_CPU)-linux
KERNEL_CROSS:=		$(STAGING_DIR)/bin/$(OPTIMIZE_FOR_CPU)-linux-uclibc-
TARGET_CROSS:=		$(STAGING_DIR)/bin/$(OPTIMIZE_FOR_CPU)-linux-uclibc-
TARGET_CC:=		$(TARGET_CROSS)gcc
STRIP:=			$(STAGING_DIR)/bin/$(OPTIMIZE_FOR_CPU)-linux-uclibc-strip
PATCH=			$(SCRIPT_DIR)/patch-kernel.sh
SED:=			$(STAGING_DIR)/bin/sed -i -e
LINUX_DIR:=		$(BUILD_DIR)/linux
LINUX_HEADERS_DIR:=	$(TOOLCHAIN_BUILD_DIR)/linux


HOST_ARCH:=		$(shell $(HOSTCC) -dumpmachine | sed -e s'/-.*//' \
			    -e 's/sparc.*/sparc/' \
			    -e 's/arm.*/arm/g' \
			    -e 's/m68k.*/m68k/' \
			    -e 's/ppc/powerpc/g' \
			    -e 's/v850.*/v850/g' \
			    -e 's/sh[234]/sh/' \
			    -e 's/mips-.*/mips/' \
			    -e 's/mipsel-.*/mipsel/' \
			    -e 's/cris.*/cris/' \
			    -e 's/i[3-9]86/i386/' \
			)

TARGET_CONFIGURE_OPTS=	PATH=$(TARGET_PATH) \
			AR=$(TARGET_CROSS)ar \
			AS=$(TARGET_CROSS)as \
			LD=$(TARGET_CROSS)ld \
			NM=$(TARGET_CROSS)nm \
			CC=$(TARGET_CROSS)gcc \
			GCC=$(TARGET_CROSS)gcc \
			CXX=$(TARGET_CROSS)g++ \
			RANLIB=$(TARGET_CROSS)ranlib

# invoke ipkg-build with some default options
IPKG_BUILD:=		PATH="$(TARGET_PATH)" ipkg-build -c -o 0 -g 0
# where to build (and put) .ipk packages
IPKG_TARGET_DIR:=	$(PACKAGE_DIR)
IPKG:=			IPKG_TMP=$(BUILD_DIR)/tmp IPKG_INSTROOT=$(TARGET_DIR) IPKG_CONF_DIR=$(STAGING_DIR)/etc IPKG_OFFLINE_ROOT=$(BUILD_DIR)/root $(SCRIPT_DIR)/ipkg -force-defaults -force-depends
IPKG_STATE_DIR:=	$(TARGET_DIR)/usr/lib/ipkg

RSTRIP:=		STRIP="$(STRIP)" $(SCRIPT_DIR)/rstrip.sh
RSTRIP_KMOD:=		STRIP="$(TARGET_CROSS)strip --strip-unneeded --remove-section=.comment" $(SCRIPT_DIR)/rstrip.sh

# XXX derive these from BR2_* vars
UNAME_S:=		Linux
UNAME_R:=		2.4.32
UNAME_M:=		mips

export UNAME_S UNAME_R UNAME_M

ifeq (${OStype},Linux)
MKPASSWD:=		$(STAGING_DIR)/bin/mkpasswd -H md5
else
MKPASSWD:=		encrypt -m
endif

EXTRACT_CMD=		mkdir -p ${WRKDIR}; \
			cd ${WRKDIR} && \
			for file in ${DISTFILES}; do case $$file in \
			*.cpio | *.tar) \
				tar xf $$file ;; \
			*.cpio.Z | *.cpio.gz | *.cgz | *.mcz | \
			    *.tar.Z | *.tar.gz | *.taz | *.tgz) \
				tar xzf $$file ;; \
			*.cpio.bz2 | *.cbz | *.tar.bz2 | *.tbz | *.tbz2) \
				bzip2 -dc $$file | cpio -mid ;; \
			*.zip) \
				unzip -d ${WRKDIR} $$file ;; \
			*) \
				echo "Cannot extract '$$file'" >&2; \
				false ;; \
			esac; done

_show:
	@echo '$($(show))'
