# $FreeWRT$
#-
# This file is part of the FreeWRT project. FreeWRT is copyrighted
# material, please see the LICENCE file in the top-level directory
# or at http://www.freewrt.org/license for details.
#-
# Note: if this file ever doesn't work on both GNU and BSD make,
# I'll use 'svn blame' and get to you personally ;-)

CP=			cp -fpR
INSTALL_DIR=		install -d -m0755
INSTALL_DATA=		install -m0644
INSTALL_BIN=		install -m0755
MAKEFLAGS=		-j$(FWRT_JLEVEL) V=$(V) $(EXTRA_MAKEFLAGS)

TARGET_CFLAGS:=		$(TARGET_OPTIMIZATION) $(TARGET_DEBUGGING)
OPTIMIZE_FOR_CPU=	$(ARCH)

BASE_DIR:=		$(TOPDIR)
DL_DIR:=		$(BASE_DIR)/dl
BUILD_DIR:=		$(BASE_DIR)/build_$(ARCH)$(ARCH_FPU_SUFFIX)
STAGING_DIR:=		$(BASE_DIR)/staging_dir_$(ARCH)$(ARCH_FPU_SUFFIX)
TOOLCHAIN_BUILD_DIR=	$(BASE_DIR)/toolchain_build_$(ARCH)$(ARCH_FPU_SUFFIX)
TOOLCHAIN_STAMP_DIR:=	$(STAGING_DIR)/stamp
TOOLS_DIR=		$(BASE_DIR)/tools
TOOLS_BUILD_DIR=	$(BASE_DIR)/tools_build
TOOLS_STAMP_DIR:=	$(STAGING_DIR)/stamp
SCRIPT_DIR:=		$(BASE_DIR)/scripts
BIN_DIR:=		$(BASE_DIR)/bin
LBIN_DIR:=		$(BASE_DIR)/lbin
PACKAGE_DIR:=		$(BIN_DIR)/packages
STAMP_DIR:=		$(BUILD_DIR)/stamp
TARGET_DIR:=		$(BUILD_DIR)/root
TARGET_PATH=		$(LBIN_DIR):$(STAGING_DIR)/usr/bin:$(STAGING_DIR)/bin:$(_PATH)
IMAGE:=			$(BUILD_DIR)/root_fs_$(ARCH)$(ARCH_FPU_SUFFIX)
REAL_GNU_TARGET_NAME=	$(OPTIMIZE_FOR_CPU)-linux-uclibc
GNU_TARGET_NAME=	$(OPTIMIZE_FOR_CPU)-linux
KERNEL_CROSS:=		$(STAGING_DIR)/bin/$(OPTIMIZE_FOR_CPU)-linux-uclibc-
TARGET_CROSS:=		$(STAGING_DIR)/bin/$(OPTIMIZE_FOR_CPU)-linux-uclibc-
TARGET_CC:=		$(TARGET_CROSS)gcc
STRIP:=			$(STAGING_DIR)/bin/$(OPTIMIZE_FOR_CPU)-linux-uclibc-strip
PATCH=			$(SCRIPT_DIR)/patch-kernel.sh
SED:=			$(STAGING_DIR)/bin/sed -i -e
LINUX_DIR:=		$(BUILD_DIR)/linux
LINUX_HEADERS_DIR:=	$(TOOLCHAIN_BUILD_DIR)/linux

TARGET_CONFIGURE_OPTS=	PATH=$(TARGET_PATH) \
			AR=$(TARGET_CROSS)ar \
			AS=$(TARGET_CROSS)as \
			LD=$(TARGET_CROSS)ld \
			NM=$(TARGET_CROSS)nm \
			CC=$(TARGET_CROSS)gcc \
			GCC=$(TARGET_CROSS)gcc \
			CXX=$(TARGET_CROSS)g++ \
			RANLIB=$(TARGET_CROSS)ranlib

# invoke ipkg-build with some default options
IPKG_BUILD:=		PATH="$(TARGET_PATH)" ipkg-build -c -o 0 -g 0
# where to build (and put) .ipk packages
IPKG_TARGET_DIR:=	$(PACKAGE_DIR)
IPKG:=			IPKG_TMP=$(BUILD_DIR)/tmp IPKG_INSTROOT=$(TARGET_DIR) \
			IPKG_CONF_DIR=$(STAGING_DIR)/etc \
			IPKG_OFFLINE_ROOT=$(BUILD_DIR)/root \
			$(SCRIPT_DIR)/ipkg -force-defaults -force-depends
IPKG_STATE_DIR:=	$(TARGET_DIR)/usr/lib/ipkg

RSTRIP:=		STRIP="$(STRIP)" $(SCRIPT_DIR)/rstrip.sh
RSTRIP_KMOD:=		STRIP="$(TARGET_CROSS)strip --strip-unneeded -R .comment" \
			$(SCRIPT_DIR)/rstrip.sh

# XXX derive these from FWRT_* vars
UNAME_S:=		Linux
UNAME_R:=		2.4.33.3
UNAME_M:=		mips

EXTRACT_CMD=		mkdir -p ${WRKDIR}; \
			cd ${WRKDIR} && \
			for file in ${DISTFILES}; do case $$file in \
			*.cpio | *.tar) \
				pax -r -s '!/\.$$!!' <$$file ;; \
			*.cpio.Z | *.cpio.gz | *.cgz | *.mcz | \
			    *.tar.Z | *.tar.gz | *.taz | *.tgz) \
				gzip -dc $$file | pax -r -s '!/\.$$!!' ;; \
			*.cpio.bz2 | *.cbz | *.tar.bz2 | *.tbz | *.tbz2) \
				bzip2 -dc $$file | pax -r -s '!/\.$$!!' ;; \
			*.zip) \
				unzip -d ${WRKDIR} $$file ;; \
			*) \
				echo "Cannot extract '$$file'" >&2; \
				false ;; \
			esac; done
