#!/bin/sh
#
# This file is part of the FreeWRT project. FreeWRT is copyrighted
# material, please see the LICENCE file in the top-level directory
# or at http://www.freewrt.org/licence for details.
#
# Christian Fischer <spaetzle@freewrt.org>
#

what=${0##*/}
case $what in
ifup)
	;;
ifdown)
	;;
*)
	echo "Usage: ifup|ifdown [options]"
	echo "For options see man busybox"
	exit 1
	;;
esac

. /etc/rc.conf
redirect="2>&-"

if [ x"$FWIFUPDOWN_DEBUG" = x"1" ]; then
	set -x
	redirect=
fi

eval IFUPDOWN_ENV= $(grep '^FWIFUPDOWN_' /etc/rc.conf |sed "s/#.*//g") \
    busybox $what $@ $redirect

# vim:ts=4
