# $FreeWRT$
#-
# This file is part of the FreeWRT project. FreeWRT is copyrighted
# material, please see the LICENCE file in the top-level directory
# or at http://www.freewrt.org/license for details.

define target_template
ifeq ($(FWRT_LINUX_$(4)),y)
KERNEL:=$(1)
BOARD:=$(2)
MODEL:=$(3)
endif
endef

# asus models
$(eval $(call target_template,2.4,brcm,asus-wl500g,2_4_BRCM_ASUS_WL500G))
$(eval $(call target_template,2.4,brcm,asus-wl500g-deluxe,2_4_BRCM_ASUS_WL500G_DELUXE))
$(eval $(call target_template,2.4,brcm,asus-wl500g-premium,2_4_BRCM_ASUS_WL500G_PREMIUM))
# linksys models
$(eval $(call target_template,2.4,brcm,linksys-wrt54gs-10,2_4_BRCM_LINKSYS_WRT54GS_1_0))
$(eval $(call target_template,2.4,brcm,linksys-wrt54gs-11,2_4_BRCM_LINKSYS_WRT54GS_1_1))
$(eval $(call target_template,2.4,brcm,linksys-wrt54gs-4,2_4_BRCM_LINKSYS_WRT54GS_4))
$(eval $(call target_template,2.4,brcm,linksys-wrt54g-10,2_4_BRCM_LINKSYS_WRT54G_1_0))
$(eval $(call target_template,2.4,brcm,linksys-wrt54g-11,2_4_BRCM_LINKSYS_WRT54G_1_1))
$(eval $(call target_template,2.4,brcm,linksys-wrt54g-20,2_4_BRCM_LINKSYS_WRT54G_2_0))
$(eval $(call target_template,2.4,brcm,linksys-wrt54g-22,2_4_BRCM_LINKSYS_WRT54G_2_2))
$(eval $(call target_template,2.4,brcm,linksys-wrt54g-30,2_4_BRCM_LINKSYS_WRT54G_3_0))
$(eval $(call target_template,2.4,brcm,linksys-wrt54gl,2_4_BRCM_LINKSYS_WRT54GL))
$(eval $(call target_template,2.4,brcm,linksys-wrt54g3g,2_4_BRCM_LINKSYS_WRT54G3G))
# netgear models
$(eval $(call target_template,2.4,brcm,netgear-wgt634u,2_4_BRCM_NETGEAR_WGT634U))


# set kernel version
ifeq ($(KERNEL),2.4)
KERNEL_VERSION=2.4.32
KERNEL_RELEASE=1
KERNEL_MOD_SUFFIX=o
endif
ifeq ($(KERNEL),2.6)
KERNEL_VERSION=2.6.17
KERNEL_RELEASE=1
KERNEL_MOD_SUFFIX=ko
endif

# set architecture
ifeq ($(BOARD),brcm)
ARCH=mips
endif

export BOARD
export ARCH
export KERNEL
export KERNEL_VERSION
export MODEL

define rootfs_template
ifeq ($(FWRT_TARGET_ROOTFS_$(2)),y)
FS:=$(1)
endif
endef

$(eval $(call rootfs_template,jffs2,JFFS2))
$(eval $(call rootfs_template,squashfs,SQUASHFS_OVERLAY))

export FS
