#!/usr/bin/env bash
# $FreeWRT: src/share/misc/licence.template,v 1.8 2006/06/16 23:03:39 tg Rel $
#-
# Copyright (c) 2006
#	Thorsten Glaser <tg@mirbsd.de>
#
# Licensee is hereby permitted to deal in this work without restric-
# tion, including unlimited rights to use, publicly perform, modify,
# merge, distribute, sell, give away or sublicence, provided all co-
# pyright notices above, these terms and the disclaimer are retained
# in all redistributions or reproduced in accompanying documentation
# or other materials provided with binary redistributions.
#
# All advertising materials mentioning features or use of this soft-
# ware must display the following acknowledgement:
#	This product includes material provided by Thorsten Glaser.
# This acknowledgement does not need to be reprinted if this work is
# linked into a bigger work whose licence does not allow such clause
# and the author of this work is given due credit in the bigger work
# or its documentation. Specifically, re-using this code in any work
# covered by the GNU General Public License version 1 or Library Ge-
# neral Public License (any version) is permitted.
#
# Licensor offers the work "AS IS" and WITHOUT WARRANTY of any kind,
# express, or implied, to the maximum extent permitted by applicable
# law, without malicious intent or gross negligence; in no event may
# licensor, an author or contributor be held liable for any indirect
# or other damage, or direct damage except proven a consequence of a
# direct error of said person and intended use of this work, loss or
# other issues arising in any way out of its use, even if advised of
# the possibility of such damage or existence of a nontrivial bug.
#-
# Scan for prerequisite host tools.

if test -z "$BASH_VERSION"; then
	echo FreeWRT requires GNU bash to be installed, sorry.
	exit 1
fi

shopt -s extglob
topdir=$(pwd)
export PATH=$topdir/lbin:$PATH

if [[ $NO_ERROR != @(0|1) ]]; then
	echo Please do not invoke this script directly!
	exit 1
fi

set -e
rm -rf $topdir/lbin/tmp
mkdir -p $topdir/lbin/tmp
cd $topdir/lbin/tmp
set +e
cat >Makefile <<'EOF'
include $(TOPDIR)/lbin/prereq.mk
all: run-test

test: test.c
	${HOSTCC} ${HOSTCFLAGS} -o $@ $^ ${LDADD}

run-test: test
	./test
EOF
cat >test.c <<-'EOF'
	#include <stdio.h>
	int
	main()
	{
		printf("Yay! Native compiler works.\n");
		return (0);
	}
EOF
X=$(gmake TOPDIR=$topdir 2>&1)
if [[ $X != *@(Native compiler works)* ]]; then
	echo Cannot compile a simple test programme.
	echo You must install GNU make and a host C compiler,
	echo usually GCC, to proceed.
	exit 1
fi
rm test*

X=$(gmake --version 2>&1 | grep '^GNU Make' | sed 's/.*\([0-9]\.[0-9]*\).*/\1/')
if [[ $X != +([0-9]).+([0-9]) ]]; then
	echo Cannot determine GNU make version number.
	exit 1
fi
let major=${X%.*}
let minor=${X#*.}
if (( (major < 3) || ((major == 3) && (minor < 81)) )); then
	echo GNU make too old.
	echo Please install GNU make 3.81 or higher to continue.
	if [[ $NO_ERROR = 1 || -s /etc/debian_version ]]; then
		echo WARNING: should abort here, continuing...
	else
		echo You can override this check, see http://www.freewrt.org/faq for details.
		exit 1
	fi
fi

if ! which flex >/dev/null 2>&1; then
	echo You must install flex to continue.
	exit 1
fi

if ! which bison >/dev/null 2>&1; then
	echo You must install GNU Bison to continue.
	echo While you can install any version, it is '*STRONGLY*' suggested
	echo to install GNU Bison version 2.3 because of its bug fixes.
	exit 1
fi
X=$(bison --version 2>&1 | fgrep 'GNU Bison' | sed 's/^[^0-9]*//')
V=old
if [[ $X = +([0-9]).+([0-9]) ]]; then
	let major=${X%.*}
	let minor=${X#*.}
	if (( (major > 2) || ((major == 2) && (minor >= 3)) )); then
		V=new
	fi
fi
if [[ $V = old ]]; then
	echo It is suggested to upgrade your copy of bison to
	echo GNU Bison 2.3 because of its bug fixes.
fi

if ! which bzip2 >/dev/null 2>&1; then
	echo You must install bzip2 to continue.
	exit 1
fi

if ! which unzip >/dev/null 2>&1; then
	echo You must install unzip to continue, sorry.
	exit 1
fi

if ! which patch >/dev/null 2>&1; then
	echo You must install patch \(from Larry Wall\) to continue.
	exit 1
fi

cat >test.c <<-'EOF'
	#include <stdio.h>
	#include <zlib.h>

	#ifndef STDIN_FILENO
	#define STDIN_FILENO 0
	#endif

	int
	main()
	{
		gzFile zstdin;
		char buf[1024];
		int i;

		zstdin = gzdopen(STDIN_FILENO, "rb");
		i = gzread(zstdin, buf, sizeof (buf));
		if ((i > 0) && (i < sizeof (buf)))
			buf[i] = '\0';
		buf[sizeof (buf) - 1] = '\0';
		printf("%s\n", buf);
		return (0);
	}
EOF
X=$(echo 'Yay! Native compiler works.' | gmake TOPDIR=$topdir LDADD=-lz 2>&1)
if [[ $X != *@(Native compiler works)* ]]; then
	echo Cannot compile a libz test programme.
	echo You must install the zlib development package,
	echo usually called libz-dev, and the run-time library.
	exit 1
fi

if ! which g++ >/dev/null 2>&1; then
	echo You must install the host GNU C++ compiler to continue.
	exit 1
fi

if ! tar --version 2>&1 | fgrep 'GNU tar' >/dev/null 2>&1; then
	echo You must install GNU tar for now, sorry...
	echo this is horrid, I know, but it will be fixed RSN.
	exit 1
fi

#if ! which perl >/dev/null 2>&1; then
if [[ "$(which perl 2>/dev/null)" != /usr/bin/perl ]]; then
	echo You must install Perl in /usr/bin to continue.
	exit 1
fi

if ! which python >/dev/null 2>&1; then
	echo You must install Python to continue, sorry.
	exit 1
fi


cd $topdir
rm -rf lbin/tmp
exit 0
