# $Id$
#--------------------------------------------------------------
# Just run 'make menuconfig', configure stuff, then run 'make'.
# You shouldn't need to mess with anything beyond this point...
#--------------------------------------------------------------

TOPDIR=${shell pwd}
export TOPDIR

CONFIG_CONFIG_IN = Config.in
CONFIG = package/config

noconfig_targets := menuconfig config oldconfig randconfig \
	allyesconfig allnoconfig tags

# Pull in the user's configuration file
ifeq ($(filter $(noconfig_targets),$(MAKECMDGOALS)),)
-include $(TOPDIR)/.config
endif

ifeq ($(strip $(BR2_HAVE_DOT_CONFIG)),y)
include $(TOPDIR)/rules.mk

all: world

.NOTPARALLEL:
.PHONY: all world clean cleandir distclean image_clean target_clean source

# In this section, we need .config
include .config.cmd

world: $(DL_DIR) $(BUILD_DIR) $(STAMP_DIR)
	${BASH} ${TOPDIR}/scripts/scan-pkgs.sh
	$(MAKE) -f build.mk tools/install toolchain/install target/compile package/compile root_clean package/install target/install package_index
	@$(TRACE) Build complete.

package_index:
	(cd $(PACKAGE_DIR); $(STAGING_DIR)/usr/bin/ipkg-make-index . > Packages)

$(DL_DIR):
	@mkdir -p $(DL_DIR)

$(BUILD_DIR):
	@mkdir -p $(BUILD_DIR)

$(STAMP_DIR):
	@mkdir -p $(STAMP_DIR)

source: tools/source toolchain/source package/source target/source

package/%:
	@$(TRACE) $@
	$(MAKE) -C package $(patsubst package/%,%,$@)

target/%:
	@$(TRACE) $@
	$(MAKE) -C target $(patsubst target/%,%,$@)

toolchain/%:
	@$(TRACE) $@
	$(MAKE) -C toolchain $(patsubst toolchain/%,%,$@)

tools/%:
	@$(TRACE) $@
	$(MAKE) -C tools $(patsubst tools/%,%,$@)

#############################################################
#
# Cleanup and misc junk
#
#############################################################
root_clean:
	@$(TRACE) root_clean
	rm -rf $(BUILD_DIR)/linux-*/root $(BUILD_DIR)/root

target_clean: root_clean
	rm -f $(STAMP_DIR)/.*-compile
	rm -f $(STAMP_DIR)/.*-install
	rm -rf $(BIN_DIR)

clean:
	@$(TRACE) clean
	@$(MAKE) -C $(CONFIG) clean
	rm -rf $(BUILD_DIR) $(BIN_DIR)

cleandir:
	@$(TRACE) cleandir
	@$(MAKE) -C $(CONFIG) clean
	rm -rf $(BUILD_DIR) $(BIN_DIR)
	rm -rf $(TOOLS_BUILD_DIR) $(TOOLCHAIN_BUILD_DIR) $(STAGING_DIR)
	rm -rf $(STAMP_DIR) $(TOOLS_STAMP_DIR) $(TOOLCHAIN_STAMP_DIR)
	rm -f .tmpconfig.h

distclean:
	@$(TRACE) distclean
	@$(MAKE) -C $(CONFIG) clean
	rm -rf $(BUILD_DIR) $(BIN_DIR) $(DL_DIR)
	rm -rf $(TOOLS_BUILD_DIR) $(TOOLCHAIN_BUILD_DIR) $(STAGING_DIR)
	rm -rf $(STAMP_DIR) $(TOOLS_STAMP_DIR) $(TOOLCHAIN_STAMP_DIR)
	rm -f .config* .tmpconfig.h

else # ifeq ($(strip $(BR2_HAVE_DOT_CONFIG)),y)

include $(TOPDIR)/lbin/prereq.mk

all: menuconfig
	@echo "Start the build with \"make\" or with \"make v\" to be verbose"

# configuration
# ---------------------------------------------------------------------------

$(CONFIG)/conf:
	$(MAKE) -C $(CONFIG) conf
$(CONFIG)/mconf:
	$(MAKE) -C $(CONFIG) 

menuconfig: $(CONFIG)/mconf
	-touch .config
	@$(CONFIG)/mconf $(CONFIG_CONFIG_IN)

config: $(CONFIG)/conf
	-touch .config
	@$(CONFIG)/conf $(CONFIG_CONFIG_IN)

oldconfig: $(CONFIG)/conf
	-touch .config
	@$(CONFIG)/conf -o $(CONFIG_CONFIG_IN)

randconfig: $(CONFIG)/conf
	-touch .config
	@$(CONFIG)/conf -r $(CONFIG_CONFIG_IN)

allyesconfig: $(CONFIG)/conf
	-touch .config
	@$(CONFIG)/conf -o $(CONFIG_CONFIG_IN)

allnoconfig: $(CONFIG)/conf
	-touch .config
	@$(CONFIG)/conf -n $(CONFIG_CONFIG_IN)

endif # ifeq ($(strip $(BR2_HAVE_DOT_CONFIG)),y)
