#!/bin/sh
#
#	Prepare the RootFS for later use. Depending on
#	the chosen target device type, do some of the following:
#	* Create initial set of device nodes.
#	* Recursively change owner to root.
#	* Copy kernel to flash. (for yaffs2)
#

MYTARGET=@@TARGET_FS@@

ME="`basename $0`"
MYDIR="`dirname $0`"
ID=`id -u`

makenode() { # (mode,name,type,major,minor)
	if [ -e $2 ]; then
		echo "skipping existing file \`$2'"
	elif ! mknod -m $1 $2 $3 $4 $5; then
		echo "error creating file \`$2', aborting!"
		exit 1
	fi
}
help_quit() { # ()
	echo "Usage:"
	echo "$ME"
	echo
	echo "Prepare the RootFS right after installation for later use."
	echo "If you want to know better, look at the source."
	exit 1
}

[ $# -gt 0 ] && { echo "Too many arguments!"; help_quit;}
[ "$ID" -ne 0 ] && { echo "You need to be root to run me!"; help_quit;}

# go to a defined place
cd "$MYDIR"

case $MYTARGET in
ext2-cf|nfs)
	echo "creating device nodes"
	makenode 0666 dev/null c 1 3
	makenode 0666 dev/tty c 5 0
	makenode 0622 dev/console c 5 1
	# for rb
	makenode 0660 dev/cfa b 13 0
	makenode 0660 dev/cfa1 b 13 1
	makenode 0660 dev/cfa2 b 13 2
	# for wrap
	makenode 0660 dev/hda b 3 0
	makenode 0660 dev/hda1 b 3 1
;;
yaffs2) # rb only
	echo "copying over device nodes"
	cp -dpR /dev/null /dev/tty /dev/console /dev/mtd* dev/
	echo "copying over kernel"
	if [ -b /dev/mtdblock0 ]; then
		mount -t yaffs2 /dev/mtdblock0 mnt/
	elif [ -b /dev/mtdblock/0 ]; then
		mount -t yaffs2 /dev/mtdblock/0 mnt/
	else
		echo "device node for first flash partition not found!"
		exit 1
	fi
	cp kernel mnt/kernel
	umount mnt/
;;
*)
	echo "something is really going wrong here!"
;;
esac

echo "recursively fixing ownership"
chown -R 0:0 *

echo "fixing /tmp permissions"
chmod 1777 tmp/

echo "setting busybox setuid"
chmod u+s bin/busybox

exit 0

