#!/bin/bash
# $FreeWRT: src/share/misc/licence.template,v 1.8 2006/06/16 23:03:39 tg Rel $
#-
# Copyright (c) 2006
#	Thorsten Glaser <tg@mirbsd.de>
#
# Licensee is hereby permitted to deal in this work without restric-
# tion, including unlimited rights to use, publicly perform, modify,
# merge, distribute, sell, give away or sublicence, provided all co-
# pyright notices above, these terms and the disclaimer are retained
# in all redistributions or reproduced in accompanying documentation
# or other materials provided with binary redistributions.
#
# All advertising materials mentioning features or use of this soft-
# ware must display the following acknowledgement:
#	This product includes material provided by Thorsten Glaser.
# This acknowledgement does not need to be reprinted if this work is
# linked into a bigger work whose licence does not allow such clause
# and the author of this work is given due credit in the bigger work
# or its documentation.
#
# Licensor offers the work "AS IS" and WITHOUT WARRANTY of any kind,
# express, or implied, to the maximum extent permitted by applicable
# law, without malicious intent or gross negligence; in no event may
# licensor, an author or contributor be held liable for any indirect
# or other damage, or direct damage except proven a consequence of a
# direct error of said person and intended use of this work, loss or
# other issues arising in any way out of its use, even if advised of
# the possibility of such damage or existence of a nontrivial bug.
#-
# Scan host-tool prerequisites of certain packages before building.

if test -z "$BASH_VERSION"; then
	echo FreeWRT requires GNU bash to be installed, sorry.
	exit 1
fi

shopt -s extglob
topdir=$(readlink -nf $(dirname $0)/..)
export PATH=$topdir/lbin:$PATH
out=0

. $topdir/.config

#-- start adding dependencies here --

if [[ -n $FWRT_COMPILE_SABLEVM_CLASSPATH ]]; then
	NEED_JIKES="$NEED_JIKES sablevm-classpath"
fi

if [[ -n $FWRT_COMPILE_AVAHI ]]; then
	NEED_PKGCONFIG="$NEED_PKGCONFIG avahi"
fi

#-- start checking dependencies here --

if [[ -n $NEED_JIKES ]]; then
	if ! which jikes >/dev/null 2>&1; then
		echo >&2 You need jikes to build $NEED_JIKES
		out=1
	fi
fi

if [[ -n $NEED_PKGCONFIG ]]; then
	if ! which pkg-config >/dev/null 2>&1; then
		echo >&2 You need pkg-config to build $NEED_PKGCONFIG
		out=1
	fi
fi

#-- end of dependency checks

exit $out
