/*
 * watch-button.c - watchdog for WRT54G3G UMTS button
 *
 * Copyright (C) 2004-2006 Markus Wigge
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id$
 *
 */

#include <stddef.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/time.h>

#define PROC_FILE "/proc/sys/button"

int proc_fd;
int pipe_fds[2];

void alrm_handler(int signo)
{
    static char last;
    char c;
    lseek(proc_fd, 0, SEEK_SET);
    if (read(proc_fd, &c, 1) == 1) {
        if ((last == '1') && (c == '0')) {
            write(pipe_fds[1], "1", 1);
        }
        last = c;
    }
    else {
        write(pipe_fds[1], "q", 1);
    }
}

int main(void)
{
    struct sigaction sa;
    struct itimerval itv, itv0;

    /*
       open pipes to communicate with signal handler
     */
    if (pipe(pipe_fds) < 0) {
        perror("pipe");
        return 1;
    }

    /*
       open status file for reading
     */
    proc_fd = open(PROC_FILE, O_RDONLY);
    if (proc_fd < 0) {
        perror(PROC_FILE);
        return 1;
    }

    /*
       Initialize signal hander
     */
    memset(&sa, 0, sizeof(sa));
    sigemptyset(&sa.sa_mask);
    sa.sa_handler = alrm_handler;
    sa.sa_flags = SA_RESTART;
    if (sigaction(SIGALRM, &sa, NULL) < 0) {
        perror("sigaction");
        return 1;
    }

    /*
       initialize/start SIGALRM timer
     */
    itv.it_interval.tv_sec   = itv.it_value.tv_sec   = 0;
    itv.it_interval.tv_usec  = itv.it_value.tv_usec  = 100000;
    itv0.it_interval.tv_sec  = itv0.it_value.tv_sec  = 0;
    itv0.it_interval.tv_usec = itv0.it_value.tv_usec = 0;
    if (setitimer(ITIMER_REAL, &itv, NULL) < 0) {
        perror("setitimer");
        return 1;
    }

    while (1) {
        char c = 0;
        if (read(pipe_fds[0], &c, 1) == 1) {
            if (c == '1') {
                char *cmd = "/sbin/hotplug button";
		// disable timer before executing
                setitimer(ITIMER_REAL, &itv0, NULL);
                system(cmd);
                // enable timer again
                setitimer(ITIMER_REAL, &itv, NULL);
            }
            else if (c == 'q') {
                return 0;
            }
        }
    }
}
